//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// CharMask
//

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <ctype.h>
#include <string.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MaskSet define
//
// Defines the characters available in the masking set
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#define MaskSet "xXaALlUu0123456789#"

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MaskCheck()
//
// Return: 0 If key doesn't conform to mask
//         1 If key does conform to mask
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int CharMask::MaskCheck(int MaskItem,int &ItemToCheck,int JustChecking)
{
  if ((MaskItem=='X' || MaskItem=='A') && !JustChecking)
    ItemToCheck-=(islower(ItemToCheck))?32:0;

  if ((MaskItem=='L' || MaskItem=='l') && !JustChecking)
    ItemToCheck+=(isupper(ItemToCheck))?32:0;

  switch(MaskItem)
  {
    case 'X':
    case 'l':
    case 'u':
    case 'x':
      if (isascii(ItemToCheck) && ItemToCheck>=' ')
        return 1;
      break;

    case 'A':
    case 'L':
    case 'U':
    case 'a':
      if (isalpha(ItemToCheck) || ItemToCheck==' ')
        return 1;
      break;

    case '#':
      if (isdigit(ItemToCheck) || ItemToCheck=='-')
        return 1;
      break;

    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      if (ItemToCheck>='0' && ItemToCheck<=MaskItem)
        return 1;
      break;
  }

  return 0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MaskShow()
//
// Handles displaying text in mask
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void CharMask::MaskShow(char *Mask,char *Value,BlazeClass &Blaze,
  int Start,int Width)
{
  int Locate=0, Size=0;

  while (*Mask)
  {
    if (!strchr(MaskSet,*Mask))
    {
      if (!Width || (Width && Locate>=Start))
      {
        Blaze << *Mask++;
        Size++;
      }
      else
        Mask++;
    }
    else
    {
      #pragma warn -lin
      #pragma warn -lvc

      if (!*Value)
      {
        if (!Width || (Width && Locate>=Start))
        {
          Blaze << ' ';
          Size++;
        }
      }
      else if (!MaskCheck(*Mask,*Value))
      {
        *Value=0;
        if (!Width || (Width && Locate>=Start))
        {
          Blaze << ' ';
          Size++;
        }
      }
      else
      {
        if (!Width || (Width && Locate>=Start))
        {
          Blaze << *(Value++);
          Size++;
        }
        else
          Value++;
      }

      #pragma warn .lin
      #pragma warn .lvc

      Mask++;
    }

    Locate++;

    if (Width && Size==Width)
      break;
  }
}

