//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// InfoBox
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>
#include <string.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// InfoBox()
//
// Constructor for InfoBox class
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

InfoBox::InfoBox()
{
  AllocationError=0;
  MessageLineStorage=NULL;
  NumberOfInfoLines=0;
  CloseIcon=1;
  TitleOfInfoBox=NULL;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ~InfoBox()
//
// Destructor for InfoBox class
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

InfoBox::~InfoBox()
{
  if (MessageLineStorage)
    free(MessageLineStorage);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Title()
//
// Define a title
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void InfoBox::Title(char *Title)
{
  TitleOfInfoBox=Title;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// NoCloseIcon()
//
// Shut off close icon
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void InfoBox::NoCloseIcon()
{
  CloseIcon=0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// operator+
//
// Define a info box message line
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

InfoBox& InfoBox::operator +(char *MessageLine)
{
  if (!AllocationError)
  {
    NumberOfInfoLines++;

    if (!(MessageLineStorage=(char **)realloc(MessageLineStorage,sizeof(char *)*NumberOfInfoLines)))
      AllocationError++;

    if (AllocationError)
      return *this;

    MessageLineStorage[NumberOfInfoLines-1]=MessageLine;
  }
  return *this;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// InfoDialog class
//
// Defines the event handler for a dialog
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

const winAcceptButton=32764;

class InfoDialog : public DialogClass
{
public:

  InfoDialog(int Width,int Height,char *Title,int CloseIcon) :
    DialogClass(Width,Height,Title,CloseIcon) { }

  int EventHandler(int Event)
  {
    if ((Event==kbEsc || Event==CloseEvent || Event==OutsideEvent)
       && Event::CloseIcon)
      return StopEvent;
    if (Event==kbCr || Event==winAcceptButton)
      return StopEvent;
    return CompleteEvent;
  }
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// UseInfoBox()
//
// Activate the menu and pass control to InfoBox class.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int InfoBox::UseInfoBox()
{
  if (AllocationError)
    return 800;

  if (!NumberOfInfoLines)
    return 900;

  for (register int i=0, Widest=0;i<NumberOfInfoLines;i++)
    if (strlen(MessageLineStorage[i])>Widest)
      Widest=strlen(MessageLineStorage[i]);

  InfoDialog &Dialog=*new InfoDialog(Widest+4,NumberOfInfoLines+6,TitleOfInfoBox,CloseIcon);

  Dialog.Element(new DiaPushButton((Widest-8)/2,NumberOfInfoLines+2,"Continue",winAcceptButton));
  Dialog.Help("Click on the Continue button or press (Return) to proceed");

  MouseHide();

  Dialog.Blaze << Colors.DiaInterior;

  for (i=0;i<NumberOfInfoLines;i++)
    Dialog.Blaze ((Widest-strlen(MessageLineStorage[i])+2)/2,1+i) <<
      MessageLineStorage[i];

  MouseShow();

  Dialog.UseDialog();

  delete &Dialog;

  return 0;
}
