//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FLIVideoProtect
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

int FLIVideoProtect = 0;

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// _FLIVideoProtect class (defined in FLI.H)
//
// This class ensures that the cursor, video mode, and video hardware are
// all returned to the status that they were in before your program began.
//
// To use this class just include "FLIVideoProtect++" anywhere in your
// program modules and it will be linked in and used automatically.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

static BlazeClass Blaze;

_FLIVideoProtect::_FLIVideoProtect()
{
  I mov ah,3
  I mov bh,0
  I int 10h

  TopCursor = _CH;
  BottomCursor = _CL;

  I mov ah,0fh
  I int 10h

  DisplayMode = _AL;

  if ((DisplayMode==2 || DisplayMode==3 || DisplayMode==7)
    && (Blaze.WhatHeight()==43 || Blaze.WhatHeight()==50))
  {
    OtherEGAVGA=EGA_VGA_43or50;
    Height=Blaze.WhatHeight();
  }
  else
  {
    OtherEGAVGA=0;
    Height=0;
  }

  return;
}

_FLIVideoProtect::~_FLIVideoProtect()
{
  MouseShutDown();

  I mov ah,1
  _CH = TopCursor;
  _CL = BottomCursor;
  I int 10h

  I mov ah,0fh
  I int 10h

  if (_AL!=DisplayMode || (!OtherEGAVGA && Height!=Blaze.WhatHeight()))
    Blaze[((!OtherEGAVGA)?DisplayMode:OtherEGAVGA)];

  if (Blaze.Intense)
    Blaze.ToggleIntense();

  -Blaze;
  Blaze.GotoXY(0,0);

  return;
}

_FLIVideoProtect _FLI_VideoProtectionFeature;
