//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// Transparent Mouse Interface
//

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#if defined(__SMALL__) || defined(__TINY__) || defined(__MEDIUM__)
#pragma option -Od
#endif
#endif

#include <dos.h>
#include <mem.h>
#include <bios.h>
#include <signal.h>

int MouseEvent=0;
int MouseButtonStatus=0;
int MouseHorizontal=0;
int MouseVertical=0;

int DoubleClickMemory=0;
long DoubleClickTimer=0;

int MouseDoubleClickFactor=10;
int MouseRepeatDelay=3;
int MouseRepeatSpeed=0;

int DoubleClickHorizontal=0;
int DoubleClickVertical=0;

int MouseAvailable;

struct _Queue
{
  int MouseEvent;
  int MouseButtonStatus;
  int MouseHorizontal;
  int MouseVertical;
} MouseQueue[200];

int MouseQueueCount=0;

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MouseHandler()
//
// The memory resident mouse event handler
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#pragma saveregs

void huge MouseHandler()
{
  int MouseEvent;
  int MouseButtonStatus;
  int MouseHorizontal;
  int MouseVertical;

  MouseEvent=_AX;
  MouseButtonStatus=_BX;

  if (!_CX)
    MouseHorizontal=0;
  else
    MouseHorizontal=_CX/8;

  if (!_DX)
    MouseVertical=0;
  else
    MouseVertical=_DX/8;

  if (MouseEvent&MouseLeftButtonRelease)
  {
    if (DoubleClickMemory)
    {
      if (DoubleClickTimer>biostime(0,0))
      {
        if (DoubleClickHorizontal==MouseHorizontal &&
          DoubleClickVertical==MouseVertical)
          MouseEvent|=MouseDoubleClick;
        DoubleClickMemory=0;
      }
      else
      {
        DoubleClickHorizontal=MouseHorizontal;
        DoubleClickVertical=MouseVertical;
        DoubleClickMemory=1;
        DoubleClickTimer=biostime(0,0)+MouseDoubleClickFactor;
      }
    }
    else
    {
ReReset:
      DoubleClickHorizontal=MouseHorizontal;
      DoubleClickVertical=MouseVertical;
      DoubleClickMemory=1;
      DoubleClickTimer=biostime(0,0)+MouseDoubleClickFactor;
    }
  }

  if (MouseQueueCount>=195)
    return; // prevents overfill of buffer

  MouseQueue[MouseQueueCount].MouseEvent=MouseEvent;
  MouseQueue[MouseQueueCount].MouseButtonStatus=MouseButtonStatus;
  MouseQueue[MouseQueueCount].MouseHorizontal=MouseHorizontal;
  MouseQueue[MouseQueueCount].MouseVertical=MouseVertical;

  MouseQueueCount++;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class MouseConnections
//
// This class connects and disconnects the memory resident mouse handling
// before the program starts and after the program exits
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class MouseConnections
{
  public:

  MouseConnections()
  {
    _AX=0;
    __int__(0x33);

    if (!_AX)
      MouseAvailable=0;
    else
    {
      MouseAvailable=1;

      _DX=FP_OFF(MouseHandler);
      _ES=FP_SEG(MouseHandler);

      _AX=0x0c;
      _CX=0x7f;

      __int__(0x33);
      MouseEvent=0;

      int Calc=(BlazeClass::WhatHeight()-1)*8;

      _CX=0;
      _DX=Calc;
      _AX=8;
      __int__(0x33);
    }
  }

  ~MouseConnections()
  {
    if (MouseAvailable)
    {
      _AX=0;
      __int__(0x33);
    }
  }
};

static MouseConnections MakeTheConnection;

static int MouseVisible=0;

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MouseHide()
//
// Hide the mouse
// Should be used before any text writes
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MouseHide()
{
  if (MouseAvailable && MouseVisible)
  {
    _AX=2;
    __int__(0x33);
    MouseVisible=0;
  }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MouseShow()
//
// Show the mouse
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MouseShow()
{
  if (MouseAvailable && !MouseVisible)
  {
    _AX=1;
    __int__(0x33);
    MouseVisible=1;
  }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MousePosition()
//
// Position the mouse
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MousePosition(int X,int Y)
{
  int NewX=X*8;
  int NewY=Y*8;

  if (MouseAvailable)
  {
    _AX=4;
    _CX=NewX;
    _DX=NewY;
    __int__(0x33);
  }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CompleteMouseReset()
//
// Reset the mouse subsystem and memory resident handler
//
// SHOULD NOT BE USED UNLESS YOU KNOW THE CONSEQUENCES -- THIS FUNCTION
// IS ONLY USED THROUGH THE MOUSERESTART() AND BLAZE CLASS EXTENDED MODE
// SWITCHING FUNCTIONS
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void CompleteMouseReset()
{
  _AX=0;
  __int__(0x33);

  if (!_AX)
  {
    MouseAvailable=0;
    return;
  }

  MouseAvailable=1;

  _DX=FP_OFF(MouseHandler);
  _ES=FP_SEG(MouseHandler);

  _AX=0x0c;
  _CX=0x7f;

  __int__(0x33);
  MouseEvent=0;

  MouseVisible=0;
  MouseQueueCount=0;

  int Calc=(BlazeClass::WhatHeight()-1)*8;

  _CX=0;
  _DX=Calc;
  _AX=8;
  __int__(0x33);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MouseShutDown()
//
// Completely shuts down the mouse subsystem
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MouseShutDown()
{
  if (MouseAvailable)
  {
    _AX=0;
    __int__(0x33);
  }
  MouseAvailable=0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MouseReStart()
//
// Completely shuts down the mouse subsystem
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MouseReStart()
{
  CompleteMouseReset();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MouseButtons()
//
// Checks the mouse button status
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int MouseButtons()
{
  if (MouseAvailable)
  {
    _AX=3;
    __int__(0x33);
    return _BX;
  }
  return 0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// GetMouseQueue()
//
// Grabs a mouse event from the mouse queue
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void GetMouseQueue()
{
  if (!MouseQueueCount)
    MouseEvent=0;
  else
  {
    MouseEvent=MouseQueue[0].MouseEvent;
    MouseButtonStatus=MouseQueue[0].MouseButtonStatus;
    MouseHorizontal=MouseQueue[0].MouseHorizontal;
    MouseVertical=MouseQueue[0].MouseVertical;
    if (MouseQueueCount==1)
      MouseQueueCount=0;
    else
      memmove(&MouseQueue[0],&MouseQueue[1],(--MouseQueueCount)*sizeof(_Queue));
  }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// FlushMouseQueue()
//
// Flushes the mouse queue
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FlushMouseQueue()
{
  MouseQueueCount=0;
  DoubleClickMemory=0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MouseLocate()
//
// Load the current mouse location
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MouseLocate()
{
  if (MouseAvailable)
  {
    _AX=3;
    __int__(0x33);
    if (!_CX)
      MouseHorizontal=0;
    else
      MouseHorizontal=_CX/8;

    if (!_DX)
      MouseVertical=0;
    else
      MouseVertical=_DX/8;
  }
}

#pragma warn .par
#pragma warn .use

