//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "elements.h"
#include "colors.h"

#include <alloc.h>
#include <string.h>

#include "yesno.h"

//---------------------------------------------------------------------------
//
// YesNo()
//
// Constructor for YesNo class.  YesNo is sorta like InfoBox except that it
// has a yes/no toggle capability.
//
//---------------------------------------------------------------------------

YesNo::YesNo()
{
  AllocationError=0;
  MessageLineStorage=NULL;
  NumberOfInfoLines=0;
  TitleOfYesNo=NULL;
}

//---------------------------------------------------------------------------
//
// ~YesNo()
//
// Destructor for YesNo class
//
//---------------------------------------------------------------------------

YesNo::~YesNo()
{
  if (MessageLineStorage)
    free(MessageLineStorage);
}

//---------------------------------------------------------------------------
//
// Title()
//
// Define a title
//
//---------------------------------------------------------------------------

void YesNo::Title(char *Title)
{
  TitleOfYesNo=Title;
}

//---------------------------------------------------------------------------
//
// operator+
//
// Define a info box message line
//
//---------------------------------------------------------------------------

YesNo& YesNo::operator +(char *MessageLine)
{
  if (!AllocationError)
  {
    NumberOfInfoLines++;

    if (!(MessageLineStorage=(char **)realloc(MessageLineStorage,sizeof(char *)*NumberOfInfoLines)))
      AllocationError++;

    if (AllocationError)
      return *this;

    MessageLineStorage[NumberOfInfoLines-1]=MessageLine;
  }
  return *this;
}

//---------------------------------------------------------------------------
//
// InfoDialog class
//
// Defines the event handler for a dialog
//
//---------------------------------------------------------------------------

const YesButton=5000;
const NoButton=5001;

class YesNoDialog : public DialogClass
{
public:

  YesNoDialog(int Width,int Height,char *Title) :
    DialogClass(Width,Height,Title) { }

  int EventHandler(int Event)
  {
    if (Event==kbEsc ||
        Event==kbCr ||
        Event==CloseEvent ||
        Event==OutsideEvent ||
        Event==YesButton ||
        Event==NoButton)
      return StopEvent;
    return CompleteEvent;
  }
};

//---------------------------------------------------------------------------
//
// UseYesNo()
//
// Activate the menu and pass control to YesNo class.
//
//---------------------------------------------------------------------------

int YesNo::UseYesNo()
{
  if (AllocationError)
    return 800;

  if (!NumberOfInfoLines)
    return 900;

  for (register int i=0, Widest=0;i<NumberOfInfoLines;i++)
    if (strlen(MessageLineStorage[i])>Widest)
      Widest=strlen(MessageLineStorage[i]);

  YesNoDialog &Dialog=*new YesNoDialog(Widest+4,NumberOfInfoLines+6,TitleOfYesNo);

  Dialog.Element(new DiaPushButton((Widest-13)/2,NumberOfInfoLines+2,"~Yes",YesButton,'Y',1));
  Dialog.Help("Yes, I acknowledge this (press Y for YES or N for NO)");

  Dialog.Element(new DiaPushButton(((Widest-13)/2)+9,NumberOfInfoLines+2,"~No",NoButton,'N'));
  Dialog.Help("No, I reject this (press Y for YES or N for NO)");

  MouseHide();

  Dialog.Blaze << Colors.DiaInterior;

  for (i=0;i<NumberOfInfoLines;i++)
    Dialog.Blaze ((Widest-strlen(MessageLineStorage[i])+2)/2,1+i) <<
      MessageLineStorage[i];

  MouseShow();

  int ReturnCode=Dialog.UseDialog();

  delete &Dialog;

  return (ReturnCode==YesButton);
}
