//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

//-------------------------------------------------------------------------
//
// SaveAs / Generate dialog
//
//-------------------------------------------------------------------------

#include "saveas.h"

// Event handler

int SaveAs::EventHandler(int Event)
{
  switch(Event)
  {
    case kbEsc:
    case kbCr:
    case CloseEvent:
    case OutsideEvent:
      return StopEvent;

    // Cases (for Push Buttons)
    // **Change to suit your needs

    case FileSaveAs:
      return StopEvent;
    case NoSave:
      return StopEvent;
  }
  return CompleteEvent;
}

// Constructor (defines your dialog)

SaveAs::SaveAs(char *Title) : DialogClass(27,7,Title)
{

  // Initialize Variables

  FileName[0]=0;

  // Declare elements, hot keys, help, and groups

  Element(new SaveAsChar(FileName));
  HotKey(1,1,Title,0);
  Help("Enter the name of the file");

  Element(new DiaPushButton(2,3,"Save!",FileSaveAs,0,1));
  Help("All right! save it!");

  Element(new DiaPushButton(13,3,"No Save",NoSave,0));
  Help("No way, dude, don't save it!");

  // ... End of dialog definition

}

SaveAsChar::SaveAsChar(char *FileName) : DiaChar(16,1,"XXXXXXXX",FileName)
{
}

int SaveAsChar::EventHandler(int Event)
{
  if (Event=='.' || Event==' ')
    return CompleteEvent;
  return DiaChar::EventHandler(Event);
}
