//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "elements.h"
#include "fliwin.h"
#include "dds.h"

#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <string.h>

//-------------------------------------------------------------------------
//
// Save a dialog file
// Version history info in LOAD.CPP
//
//-------------------------------------------------------------------------

#define CurrentFileVersion 6

void stringwrite(int Save,char *String)
{
  int Length=strlen(String)+1;
  write(Save,&Length,sizeof(int));
  write(Save,String,Length);
}

void DialogWindow::SaveFile(char *SavedName)
{
  //-------------------------------------------------------------------------
  //
  // Open file for save (truncate or create, if necessary)
  //
  //-------------------------------------------------------------------------

  int Save=open(SavedName,O_RDWR|O_TRUNC|O_CREAT|O_BINARY,S_IREAD|S_IWRITE);

  //-------------------------------------------------------------------------
  //
  // Put DDS file signature into file
  //
  //-------------------------------------------------------------------------

  char FileSignature[] = "[DDS/SD]";
  write(Save,&FileSignature,sizeof(FileSignature));

  //-------------------------------------------------------------------------
  //
  // Save current file version #
  //
  // Save the *file* current version number, for possible usage when the
  // DDS is upgraded or when a new product is introduced.  This will
  // help maintain compatibility across versions.
  //
  //-------------------------------------------------------------------------

  int CurVersion=CurrentFileVersion;

  write(Save,&CurVersion,sizeof(int));

  //-------------------------------------------------------------------------
  //
  // Save global dialog characteristics
  //
  //-------------------------------------------------------------------------

  write(Save,&CurrentColor,sizeof(int));
  write(Save,&ZPositioning,sizeof(int));

  if (!Title)
  {
    char Title[50]="\0"; // Avoids saving junk to the file
    stringwrite(Save,Title);
  }
  else
    stringwrite(Save,Title);

  stringwrite(Save,DerivedClass);

  int Width=Blaze.WhatWinWidth()+2;
  int Height=Blaze.WhatWinHeight()+2;

  write(Save,&Width,sizeof(int));
  write(Save,&Height,sizeof(int));
  write(Save,&X,sizeof(int));
  write(Save,&Y,sizeof(int));

  //-------------------------------------------------------------------------
  //
  // Save the text that appears inside of the window (the typed stuff)
  //
  //-------------------------------------------------------------------------

  Width-=2;
  Height-=2;

  for (int i=0;i<Height;i++)
    write(Save,Interior[i],Width*2);

  //-------------------------------------------------------------------------
  //
  // Save the piece count
  //
  //-------------------------------------------------------------------------

  write(Save,&NumberPieces,sizeof(int));

  //-------------------------------------------------------------------------
  //
  // Save the elements in the order in which they were in when the
  // dialog was created and last manipulated
  //
  //-------------------------------------------------------------------------

  if (NumberPieces)
  {
    for (i=0;i<NumberPieces;i++)
    {
      //----------------------------------------------------------------------
      //
      // This set of variables is saved in the same spot for all elements.
      //
      // The "LAYOUT" member is the signature for this element.
      //
      //----------------------------------------------------------------------

      write(Save,&Pieces[i]->LayOut,sizeof(int));
      write(Save,&Pieces[i]->X,sizeof(int));
      write(Save,&Pieces[i]->Y,sizeof(int));
      write(Save,&Pieces[i]->Width,sizeof(int));
      write(Save,&Pieces[i]->Height,sizeof(int));
      write(Save,&Pieces[i]->Color,sizeof(int));

      //----------------------------------------------------------------------
      //
      // Save information that is specific to each type of element or
      // object.
      //
      //----------------------------------------------------------------------

      switch(Pieces[i]->LayOut)
      {
        case PieceHandler::Character:
        case PieceHandler::Integer:
        case PieceHandler::Long:
        case PieceHandler::Float:
        case PieceHandler::Double:
        case PieceHandler::Bcd:
          stringwrite(Save,Pieces[i]->Mask);
          stringwrite(Save,Pieces[i]->Variable);
          stringwrite(Save,Pieces[i]->Prompter);
          stringwrite(Save,Pieces[i]->HotKey);
          write(Save,&Pieces[i]->GroupCode,sizeof(int));
          write(Save,&Pieces[i]->HelpId,sizeof(int));
          write(Save,&Pieces[i]->ToBeDerived,sizeof(int));
          write(Save,&Pieces[i]->PromptX,sizeof(int));
          write(Save,&Pieces[i]->PromptY,sizeof(int));
          stringwrite(Save,Pieces[i]->DerivedClass);
          stringwrite(Save,Pieces[i]->Help);
          write(Save,&Pieces[i]->Focus_Reset,sizeof(int));
          if (Pieces[i]->LayOut==PieceHandler::Character)
          {
            write(Save,&Pieces[i]->MaskCharacter,sizeof(int));
            write(Save,&Pieces[i]->MaskWidth,sizeof(int));
            write(Save,&Pieces[i]->ScrollWidth,sizeof(int));
          }
          break;
        case PieceHandler::Check:
          stringwrite(Save,Pieces[i]->Text);
          stringwrite(Save,Pieces[i]->Variable);
          stringwrite(Save,Pieces[i]->HotKey);
          write(Save,&Pieces[i]->GroupCode,sizeof(int));
          write(Save,&Pieces[i]->HelpId,sizeof(int));
          write(Save,&Pieces[i]->ToBeDerived,sizeof(int));
          stringwrite(Save,Pieces[i]->DerivedClass);
          stringwrite(Save,Pieces[i]->Help);
          break;
        case PieceHandler::Push:
          stringwrite(Save,Pieces[i]->Text);
          stringwrite(Save,Pieces[i]->Constant);
          stringwrite(Save,Pieces[i]->HotKey);
          write(Save,&Pieces[i]->GroupCode,sizeof(int));
          write(Save,&Pieces[i]->HelpId,sizeof(int));
          write(Save,&Pieces[i]->ToBeDerived,sizeof(int));
          stringwrite(Save,Pieces[i]->DerivedClass);
          stringwrite(Save,Pieces[i]->Help);
          write(Save,&Pieces[i]->Focus_Reset,sizeof(int));
          break;
        case PieceHandler::GroupHeading:
          stringwrite(Save,Pieces[i]->Text);
          stringwrite(Save,Pieces[i]->HotKey);
          write(Save,&Pieces[i]->GroupCode,sizeof(int));
          break;
        case PieceHandler::VRadio:
        case PieceHandler::HRadio:
          stringwrite(Save,Pieces[i]->Variable);
          stringwrite(Save,Pieces[i]->Prompter);
          stringwrite(Save,Pieces[i]->HotKey);
          write(Save,&Pieces[i]->GroupCode,sizeof(int));
          write(Save,&Pieces[i]->HelpId,sizeof(int));
          write(Save,&Pieces[i]->ToBeDerived,sizeof(int));
          write(Save,&Pieces[i]->PromptX,sizeof(int));
          write(Save,&Pieces[i]->PromptY,sizeof(int));
          stringwrite(Save,Pieces[i]->DerivedClass);
          stringwrite(Save,Pieces[i]->Help);
          for (int j=0;j<10;j++)
            stringwrite(Save,Pieces[i]->Elements[j]);
          break;
        case PieceHandler::PickGeneric:
          stringwrite(Save,Pieces[i]->Prompter);
          stringwrite(Save,Pieces[i]->HotKey);
          write(Save,&Pieces[i]->HelpId,sizeof(int));
          write(Save,&Pieces[i]->ToBeDerived,sizeof(int));
          write(Save,&Pieces[i]->PromptX,sizeof(int));
          write(Save,&Pieces[i]->PromptY,sizeof(int));
          stringwrite(Save,Pieces[i]->DerivedClass);
          stringwrite(Save,Pieces[i]->Help);
      }
    }
  }

  close(Save);
}

