//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fli.h"
#include "elements.h"
#include "colors.h"
#include "fliwin.h"
#include "dds.h"

#pragma warn -inl

//-------------------------------------------------------------------------
//
// Character plopping element
//
//-------------------------------------------------------------------------

class PlopChar : public DialogElement
{
private:

	int &CurrentItem;

public:

	PlopChar(int _X,int _Y,int &Item) : CurrentItem(Item)
	{
		X=_X;
		Y=_Y;
		Width=32;
		Height=8;
	}
	void Show();
	void HighLight();
	void UnHighLight();
	int EventHandler(int Event);
};

//-------------------------------------------------------------------------
//
// Show the plop list
//
//-------------------------------------------------------------------------

void PlopChar::Show()
{
	MouseHide();
	(*Blaze) << Colors.RadioText;

	for (int i=0;i<8;i++)
		for (int j=0;j<32;j++)
			(*Blaze)(X+j,Y+i) << (char)((i || j)?((i*32)+j):' ');

	HighLight();

	MouseShow();
}

//-------------------------------------------------------------------------
//
// Highlight an entry on the plop list
//
//-------------------------------------------------------------------------

void PlopChar::HighLight()
{
	MouseHide();

	(*Blaze) << Colors.RadioHiLite;

	int YLoc=CurrentItem/32;
	int XLoc=CurrentItem-(YLoc*32);

	(*Blaze) (X+XLoc,Y+YLoc) << (char)((CurrentItem)?(((YLoc*32))+XLoc):' ');

	Blaze->WindowGotoXY(X+XLoc,Y+YLoc);

	MouseShow();
}

//-------------------------------------------------------------------------
//
// UnHighlight an entry on the plop list
//
//-------------------------------------------------------------------------

void PlopChar::UnHighLight()
{
	MouseHide();

	(*Blaze) << Colors.RadioText;

	int YLoc=CurrentItem/32;
	int XLoc=CurrentItem-(YLoc*32);

	(*Blaze) (X+XLoc,Y+YLoc) << (char)((CurrentItem)?(((YLoc*32))+XLoc):' ');

	Blaze->WindowGotoXY(X+XLoc,Y+YLoc);

	MouseShow();
}

//-------------------------------------------------------------------------
//
// Main event handler for plop element
//
//-------------------------------------------------------------------------

int PlopChar::EventHandler(int Event)
{
	if (Event==kbRight)
	{
		UnHighLight();
		CurrentItem=(CurrentItem==255)?0:(++CurrentItem);
		HighLight();
		return CompleteEvent;
	}

	if (Event==kbLeft)
	{
		UnHighLight();
		CurrentItem=(!CurrentItem)?255:(--CurrentItem);
		HighLight();
		return CompleteEvent;
	}

	if (Event==kbDown)
	{
		UnHighLight();
		CurrentItem=(CurrentItem>=224)?(CurrentItem-224):(CurrentItem+32);
		HighLight();
		return CompleteEvent;
	}

	if (Event==kbUp)
	{
		UnHighLight();
		CurrentItem=(CurrentItem<33)?(CurrentItem+224):(CurrentItem-32);
		HighLight();
		return CompleteEvent;
	}

	if (Event==ValidatedMousedEvent)
	{
		if (MouseButtonStatus&LeftButton)
		{
			UnHighLight();
			CurrentItem=
				((MouseVertical-DialogElement::Y)*32)+
				(MouseHorizontal-DialogElement::X);
			HighLight();
			return CompleteEvent;
		}
	}

	return Event;
}

//-------------------------------------------------------------------------
//
// Main dialog that uses the plop element that we just invented
//
//-------------------------------------------------------------------------

const plopDrop=10000;
const plopCancel=10001;

class PlopDialog : public DialogClass
{
public:

	PlopDialog() : DialogClass(56,14,"Plop")
		{  }

	int EventHandler(int Event)
	{
		if (Event==kbEsc ||
				Event==kbCr ||
				Event==CloseEvent ||
				Event==OutsideEvent ||
				Event==plopDrop ||
				Event==plopCancel)
			return StopEvent;
		return CompleteEvent;
	}
};

//-------------------------------------------------------------------------
//
// Call up and display the character plopping dialog
//
//-------------------------------------------------------------------------

int DialogWindow::PlopCharacter()
{
  PlopDialog &Dialog=*new PlopDialog();

	int PlopCharacter=0;

	Dialog.Element(new PlopChar(3,2,PlopCharacter));
	Dialog.HotKey(10,1,"~Character to Plop",kbAltC);
	Dialog.Help("Select this foreground palette color");

  Dialog.Element(new DiaPushButton(41,4,"Plop It!",plopDrop,0,1));
	Dialog.Help("Change to this palette color");

	Dialog.Element(new DiaPushButton(41,7," Cancel ",plopCancel));
	Dialog.Help("Do not change the color");

	Dialog.Blaze.Box(1,1,36,10,Colors.DiaInterior);

	int Remember=Dialog.UseDialog();

	if (Remember!=kbCr && Remember!=plopDrop)
		PlopCharacter=0;

  delete &Dialog;

	return PlopCharacter;
}

