//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fliwin.h"
#include "colors.h"
#include "dds.h"

#include <stdio.h>
#include <alloc.h>
#include <mem.h>

//-------------------------------------------------------------------------
//
// Displays prompter for elements
//
//-------------------------------------------------------------------------

#define Prompt \
  if (Prompter && *Prompter) \
  { \
    Blaze->QuickDisplay(PromptX,PromptY, \
      Colors.DiaQuickKey,Colors.DiaLocator,Prompter); \
  } \

//-------------------------------------------------------------------------
//
// Draws a box
//
//-------------------------------------------------------------------------

void Box::DrawFigure()
{
  Blaze->Box(X,Y,Width,Height,Color);
}

void Box::Size(int X,int Y)
{
  Width+=X;
  Height+=Y;
  if (Width<2)
    Width=2;
  if (Height<2)
    Height=2;
}

//-------------------------------------------------------------------------
//
// Draws a filled box
//
//-------------------------------------------------------------------------

void FilledBox::DrawFigure()
{
  Blaze->BoxFilled(X,Y,Width,Height,Color);
}

void FilledBox::Size(int X,int Y)
{
  Width+=X;
  Height+=Y;
  if (Width<2)
    Width=2;
  if (Height<2)
    Height=2;
}

//-------------------------------------------------------------------------
//
// Draws a horizontal line
//
//-------------------------------------------------------------------------

void HorizontalLine::DrawFigure()
{
  Blaze->CharacterRepeater(X,Y,Width,Color,'\xc4');
}

void HorizontalLine::Size(int X,int Y)
{
  Width+=X;
  if (Width<1)
    Width=1;
}

//-------------------------------------------------------------------------
//
// Draws a vertical line
//
//-------------------------------------------------------------------------

void VerticalLine::DrawFigure()
{
  Blaze->CharacterRepeaterDown(X,Y,Height,Color,'\xb3');
}

void VerticalLine::Size(int X,int Y)
{
  Height+=Y;
  if (Height<1)
    Height=1;
}

//-------------------------------------------------------------------------
//
// Draws a shadow
//
//-------------------------------------------------------------------------

void Shadow::DrawFigure()
{
  Blaze->Shadow(X,Y,Width,Height);
}

void Shadow::Size(int X,int Y)
{
  Width+=X;
  Height+=Y;
  if (Width<1)
    Width=1;
  if (Height<1)
    Height=1;
}

//-------------------------------------------------------------------------
//
// Draws an erased area
//
//-------------------------------------------------------------------------

void EraseArea::DrawFigure()
{
  Blaze->EraseArea(X,Y,Width,Height,Color);
}

void EraseArea::Size(int X,int Y)
{
  Width+=X;
  Height+=Y;
  if (Width<1)
    Width=1;
  if (Height<1)
    Height=1;
}

//-------------------------------------------------------------------------
//
// Draws a colorized area
//
//-------------------------------------------------------------------------

void ColorizeArea::DrawFigure()
{
  Blaze->BoxAttribute(X,Y,Width,Height,Color);
}

void ColorizeArea::Size(int X,int Y)
{
  Width+=X;
  Height+=Y;
  if (Width<1)
    Width=1;
  if (Height<1)
    Height=1;
}

//-------------------------------------------------------------------------
//
// Displays a character element
//
//-------------------------------------------------------------------------

void Character::DrawFigure()
{
  if (!ScrollWidth && !MaskWidth)
    (*Blaze) (X,Y) << Color << Mask;
  else
  {
    Blaze->CharacterRepeater(X,Y,Width,Color,' ');
    (*Blaze) << Color;
    if (ScrollWidth)
    {
      (*Blaze) (X,Y) << '\x11';
      (*Blaze) (X+Width-1,Y) << '\x10';
    }
    if (MaskWidth)
    {
      Blaze->CharacterRepeater(X+((ScrollWidth)?1:0),Y,
        (ScrollWidth)?(Width-2):MaskWidth,Color,MaskCharacter);
    }
    else
    {
      (*Blaze) (X+1,Y);
      for (int i=0;i<Width-2;i++)
        (*Blaze) << (char)Mask[i];
    }
  }
  Prompt;
}

//-------------------------------------------------------------------------
//
// Displays an integer element
//
//-------------------------------------------------------------------------

void Integer::DrawFigure()
{
  (*Blaze) (X,Y) << Color << Mask;
  Prompt;
}

//-------------------------------------------------------------------------
//
// Displays a long element
//
//-------------------------------------------------------------------------

void Long::DrawFigure()
{
  (*Blaze) (X,Y) << Color << Mask;
  Prompt;
}

//-------------------------------------------------------------------------
//
// Displays a float element
//
//-------------------------------------------------------------------------

void Float::DrawFigure()
{
  (*Blaze) (X,Y) << Color << Mask;
  Prompt;
}

//-------------------------------------------------------------------------
//
// Displays a double element
//
//-------------------------------------------------------------------------

void Double::DrawFigure()
{
  (*Blaze) (X,Y) << Color << Mask;
  Prompt;
}

//-------------------------------------------------------------------------
//
// Displays a bcd element
//
//-------------------------------------------------------------------------

void Bcd::DrawFigure()
{
  (*Blaze) (X,Y) << Color << Mask;
  Prompt;
}

//-------------------------------------------------------------------------
//
// Displays a check box element
//
//-------------------------------------------------------------------------

void Check::DrawFigure()
{
  (*Blaze) (X,Y) << Color << " [ ] ";
  Blaze->QuickDisplay(X+5,Y,Colors.CheckQuickKey,Colors.CheckText,Text);
  (*Blaze) << ' ';
}

//-------------------------------------------------------------------------
//
// Displays a push button element
//
//-------------------------------------------------------------------------

void Push::DrawFigure()
{
  (*Blaze) (X,Y)
    << Colors.ButtonNormal
    << ' ';

  Blaze->QuickDisplay(X+1,Y,Colors.ButtonBold,Colors.ButtonNormal,Text);

  (*Blaze)
    << Colors.ButtonNormal
    << ' '
    << Colors.DiaInterior
    << '\xdc';

  Blaze->CharacterRepeater(X+1,Y+1,Width,Colors.DiaInterior,223);
}

//-------------------------------------------------------------------------
//
// Displays a group heading (not an element)
//
//-------------------------------------------------------------------------

void GroupHeading::DrawFigure()
{
  Blaze->QuickDisplay(X,Y,
    Colors.DiaHeadingQuickKey,Colors.DiaHeading,Text);
}

//-------------------------------------------------------------------------
//
// Displays a horizontal radio element
//
//-------------------------------------------------------------------------

void HRadio::DrawFigure()
{
  (*Blaze) (X,Y) << Color << ' ';

  for (int i=0;i<10;i++)
  {
    if (!*(Elements[i]+0))
      break;

    (*Blaze) << "( ) " << Elements[i] << ' ';
  }

  Prompt;
}

//-------------------------------------------------------------------------
//
// Displays a vertical radio element
//
//-------------------------------------------------------------------------

void VRadio::DrawFigure()
{
  Blaze->EraseArea(X,Y,Width,Height,Color);
  (*Blaze) << Color;


  for (int i=0;i<10;i++)
  {
    if (!*(Elements[i]+0))
      break;

    (*Blaze) (X+1,Y+i) << "( ) " << Elements[i];
  }

  Prompt;
}

//-------------------------------------------------------------------------
//
// Displays a pick list element
//
//-------------------------------------------------------------------------

void PickGeneric::DrawFigure()
{
  Blaze->EraseArea(X,Y,Width,Height,Color);
  Blaze->CharacterRepeaterDown(X+Width-1,Y,Height,Colors.PickButton,177);
  (*Blaze) (X+Width-1,Y) << Colors.PickButton << '\x1e';
  (*Blaze) (X+Width-1,Y+Height-1) << '\x1f';
  Prompt;
}

