//
// The Fusion Library Interface for DOS
// Version 1.01
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

//-------------------------------------------------------------------------
//
// Main Handler for objects and elements
//
//-------------------------------------------------------------------------

class PieceHandler
{
public:
	enum
	{

    // Objects

    Box = 0,
		FilledBox,
		HorizontalLine,
		VerticalLine,
		Shadow,
		EraseArea,
    ColorizeArea,
    __DUMMY__=50,

    // Elements

    Character,
    Integer,
    Long,
    Float,
    Double,
    Bcd,
    VRadio,
    HRadio,
    Check,
    Push,
    PickGeneric,
    __DUMMY2__=100,

    // Non Classifiable

    GroupHeading
  } LayOut;

  // For objects and elements

  int X, Y;                   // Location of object
  int PromptX, PromptY;       // Location of prompter
  int Width, Height;          // Width / Height of object
  int Color;                  // Color of object

  // For character elements

  int MaskCharacter;          // For QUICK masks
  int MaskWidth;
  int ScrollWidth;            // Actual scroll width
  int Focus_Reset;            // Is it focused or reset?

  // These are only allocated if necessary

  char *Mask;                 // Mask for characters/numerics   [50 wide]
  char *Variable;             // Variable to store result in    [50 wide]
  char *Prompter;             // Prompter for element           [50 wide]
  char *HotKey;               // Hot key to jump to element     [30 wide]
  char **Elements;            // List of radio buttons          [10 @ 50 wide]
  char *Help;                 // Help for element               [65 wide]
  char *DerivedClass;         // Name of element derived class  [50 wide]
  char *Text;                 // Text for button or check box   [50 wide]
  char *Constant;             // for push buttons               [50 wide]

  // For elements only

  int GroupCode;              // What group does this belong to?
  int HelpId;                 // Help screen id code
  int ToBeDerived;            // Is class derived

  BlazeClass *Blaze;          // Pointer to Blaze for inside of window

	virtual void DrawFigure() = 0;
  virtual void Size(int,int);
  PieceHandler(BlazeClass *_Blaze=0) : Blaze(_Blaze) { }
  virtual ~PieceHandler();
};

//-------------------------------------------------------------------------
//
// Macro to derive a class for objects
//
//-------------------------------------------------------------------------

#define Fig(A) \
class A : public PieceHandler \
{ \
	public: \
    A(BlazeClass *_Blaze_,int X=0,int Y=0,int Width=0,int Height=0,int Color=0); \
    A(PieceHandler &Object); \
    void DrawFigure(); \
    void Size(int,int); \
};

//-------------------------------------------------------------------------
//
// Macro to derive a class for elements
//
//-------------------------------------------------------------------------

#define Elem(A) \
class A : public PieceHandler \
{ \
	public: \
    A(BlazeClass *_Blaze_,int X=0,int Y=0,int Width=0,int Height=0,int Color=0); \
    A(PieceHandler &Object); \
    void DrawFigure(); \
};

//-------------------------------------------------------------------------
//
// Derive and create classes for both elements and objects
//
//-------------------------------------------------------------------------

Fig(Box);
Fig(FilledBox);
Fig(HorizontalLine);
Fig(VerticalLine);
Fig(Shadow);
Fig(EraseArea);
Fig(ColorizeArea);

Elem(Character);
Elem(Integer);
Elem(Long);
Elem(Float);
Elem(Double);
Elem(Bcd);
Elem(VRadio);
Elem(HRadio);
Elem(Check);
Elem(Push);
Elem(GroupHeading);
Elem(PickGeneric);
