//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "elements.h"
#include "mask.h"
#include "colors.h"

#include <string.h>

const layoutContinue=30000;
const layoutCancel=30001;
const layoutButtons=30002;

//-------------------------------------------------------------------------
//
// Event handler for the radio button definition dialog
// This dialog defines each button
//
//-------------------------------------------------------------------------

int PickDialog::EventHandler(int Event)
{
	if (Event==kbEsc ||
			Event==kbCr ||
			Event==CloseEvent ||
			Event==OutsideEvent ||
			Event==layoutContinue ||
			Event==layoutCancel)
		return StopEvent;
	return CompleteEvent;
}

//-------------------------------------------------------------------------
//
// Define the global radio button dialog
//
//-------------------------------------------------------------------------

PickDialog::PickDialog(int Hp,int Wide,int Hi) :
  DialogClass(78,16,"Pick List Specifications")
{
  Prompter[0]=0;
  HotKeyDefine[0]=0;
  DerivedClass[0]=0;
  HelpLine[0]=0;

  HelpScreen=Hp;
  Width=Wide;
  Height=Hi;

  Blaze.Box(1,1,57,9,Colors.DiaInterior);
  Blaze.Box(1,10,74,3,Colors.DiaInterior);

  GroupHeading(18,1,1,"Element ~Characteristics",kbAltC);
  GroupHeading(30,10,3,"Help/Prompt ~Line",kbAltL);

  GroupElement(1,new DiaInt(22,2,"###",Width));
  Help("Enter the width of this pick list");
  HotKey(3,2,"~Width of Pick List",kbAltW);

  GroupElement(1,new DiaInt(53,2,"###",Height));
  Help("Enter the height of this pick list");
  HotKey(33,2,"~Height of Pick List",kbAltH);

	GroupElement(1,new DiaChar(12,4,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",Prompter));
	Help("Enter the prompter to use for this element (~ for hot key)");
	HotKey(3,4,"~Prompter",kbAltP);

	GroupElement(1,new DiaChar(11,6,0,HotKeyDefine,0,'x',29));
  Help("Enter the hot key #define to assign to this element (0 for none)");
	HotKey(3,6,"~Hot Key",kbAltH);

	GroupElement(1,new DiaInt(51,6,"#####",HelpScreen));
	Help("Enter the help screen for this element (0 for none)");
	HotKey(43,6,"~Help Id",kbAltG);

	GroupElement(1,new DiaChar(19,8,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",DerivedClass));
	Help("Enter the name of the derived class");
	HotKey(3,8,"~Name of Derived",kbAltN);

	GroupElement(3,new DiaChar(13,11,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",HelpLine));
	Help("Help that you would like to appear at the bottom of the screen");
	HotKey(3,11,"Help ~Line",kbAltL);

  Element(new DiaPushButton(62,3,"Continue",layoutContinue,0,1));
	Help("Accept this title and continue");

  Element(new DiaPushButton(63,6,"Cancel",layoutCancel));
	Help("Do not accept this title");
}

//-------------------------------------------------------------------------
//
// Get the global radio button information
//
//-------------------------------------------------------------------------

int PickDialog::GetPick()
{
DoAgain:

	int Save=UseDialog();

	if (Save==kbCr || Save==layoutContinue)
  {
    if (!Width || !Height)
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you define the width and"
        + "height before I can declare this"
        + "pick list.";

      NotValid.Title("Dimensions Necessary");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (Width<3 || Height<3)
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, the pick list dimensions must"
        + "be at least 3x3.  In other words, at"
        + "least 3 wide and 3 high.";

      NotValid.Title("Too thin");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (Prompter[0] && !HotKeyDefine[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, if you define a prompter"
        + "you MUST define a hot key to"
        + "accompany it.  Enter a \"0\" in the"
        + "input spot if there isn't one.";

      NotValid.Title("Need a Hot Key");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (HelpScreen && (HelpScreen<1000 || HelpScreen>32000))
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, the help screen that you"
        + "specified is invalid.  It must"
        + "be between 1000 and 32000.";

      NotValid.Title("Incorrect Help");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (!DerivedClass[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, a name for the derived"
        + "class must be specified.";

      NotValid.Title("Missing Derived");
      NotValid.UseInfoBox();

      goto DoAgain;
    }

    return 1;
  }

  return 0;
}
