//
// The Fusion Library Interface for DOS
// Version 1.01
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//
//
// To use this dialog in your own program, here is all you have to do:
//
//   1. Include OPEN.H in your module
//   2. Place the following code where you want to bring up the dialog:
//         OpenDialog &Open=*new OpenDialog("*.*");
//         char *File=Open.OpenFile();
//         delete &Open;
//   3. The computer returns a pointer to a string that refers to the
//      file that should be opened.  If it is NULL then no file was
//      selected.  Be sure to copy the info contained in the returned
//      string or you may have problems when you destruct the Open
//      dialog -- since the string is a static.
//   4. That is it!!
//

#include "elements.h"
#include <dir.h>

#include "chgdir.h" // requires chgdir for directory movement

//-------------------------------------------------------------------------
//
// FileStorage class that stores file information
//
//-------------------------------------------------------------------------

class FileStorage
{
public:

  ffblk *DirEntries;
  int Count;

  char Mask[80];

  FileStorage(char *_Mask);
  ~FileStorage();

  void Refresh();
};

//-------------------------------------------------------------------------
//
// ChDirDialog class that controls the entire dialog
//
//-------------------------------------------------------------------------

class FileList;
class FilePath;

class OpenDialog : public DialogClass
{
public:

  PathStorage *Path;
  FileStorage *File;
  FilePath *FilePathed;
  FileList *FileLister;

  char FileCompute[100];
  char Value[100];

  OpenDialog(char *_Mask=0);
  ~OpenDialog();

  char *OpenFile();

  int EventHandler(int Event);
};

//-------------------------------------------------------------------------
//
// FileList class that lists the available files
//
//-------------------------------------------------------------------------

class Prompt2;

class FileList : public DiaStructPickList
{
public:

  FileStorage &File;
  Prompt2 *Prompt;
  static int CurrentItem;

  FileList(int X,int Y,FileStorage &_File);

  int EventHandler(int Event);
  void Show();
};

//-------------------------------------------------------------------------
//
// FilePath class that handles the dir path
//
//-------------------------------------------------------------------------

class FilePath : public DiaChar
{
public:

  PathStorage &Path;
  FileStorage &File;
  char *ComparePathStorage;
  char GetMask[20];

  int Reset;

  FilePath(int X,int Y,PathStorage &_Path,FileStorage &_File,char *Merge);
  ~FilePath();

  int EventHandler(int Event);
  int Departure();
};

//-------------------------------------------------------------------------
//
// ChDirList2 class that lists the available directories
//
//-------------------------------------------------------------------------

class ChDirList2 : public DiaStructPickList
{
public:

  PathStorage &Path;
  FileStorage &File;
  FilePath &PathEntry;
  static int CurrentItem;

  ChDirList2(int X,int Y,PathStorage &_Path,FileStorage &_File,
    FilePath &_PathEntry);

  int EventHandler(int Event);
  void Show();
};

//-------------------------------------------------------------------------
//
// DirList2 class that lists all of the available drives
//
//-------------------------------------------------------------------------

class DirList2 : public DiaStructPickList
{
public:

  PathStorage &Path;
  FileStorage &File;
  FilePath &PathEntry;

  DirList2(int X,int Y,PathStorage &_Path,FileStorage &_File,
    FilePath &_PathEntry);

  int EventHandler(int Event);
};

//-------------------------------------------------------------------------
//
// Prompt2 class indiciates current location
//
//-------------------------------------------------------------------------

class Prompt2 : public DialogElement
{
public:

  PathStorage &Path;
  FileStorage &File;
  FileList &List;

  Prompt2(PathStorage &_Path,FileStorage &_File,FileList &_List);

  void Show();
  void HighLight();
  int Available();
  int EventHandler(int Event);
};
