//
// The Fusion Library Interface for DOS
// Version 1.01
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

//-------------------------------------------------------------------------
//
// Get the character or numeric mask
//
//-------------------------------------------------------------------------

class MaskDialog : public DialogClass
{
public:

  char ElementMask[50];
  char VariableName[50];
  char Prompter[50];
  char HotKeyDefine[30];
  char DerivedClass[50];
  char HelpLine[65];

  int GroupingCode;
  int HelpScreen;
  int SetForLiving;

  int CharacterActive;

  char MaskCharacter[2];
  int MaskWidth;
  int ScrollWidth;

	MaskDialog(int=0,int=0,int=0);

	int EventHandler(int);
  int GetMask();
};

//-------------------------------------------------------------------------
//
// Get the check mark information
//
//-------------------------------------------------------------------------

class CheckDialog : public DialogClass
{
public:

  char CheckText[50];
  char VariableName[50];
  char HotKeyDefine[30];
  char DerivedClass[50];
  char HelpLine[65];

  int GroupingCode;
  int HelpScreen;
  int SetForLiving;

	CheckDialog(int=0,int=0,int=0);

	int EventHandler(int);
  int GetCheck();
};

//-------------------------------------------------------------------------
//
// Get the push button information
//
//-------------------------------------------------------------------------

class PushDialog : public DialogClass
{
public:

  char PushText[50];
  char HotKeyDefine[30];
  char Constant[50];
  char DerivedClass[50];
  char HelpLine[65];

  int GroupingCode;
  int HelpScreen;
  int SetForLiving;

	PushDialog(int=0,int=0,int=0);

	int EventHandler(int);
  int GetPush();
};

//-------------------------------------------------------------------------
//
// Get the group heading information
//
//-------------------------------------------------------------------------

class GroupDialog : public DialogClass
{
public:

  char GroupText[50];
  char HotKeyDefine[30];

  int GroupingCode;

	GroupDialog(int=0);

	int EventHandler(int);
  int GetGroup();
};

//-------------------------------------------------------------------------
//
// Get the radio button information
//
// 2 classes - RadioDialog is for master dialog
//             ButtonDialog is to get button headings
//
//-------------------------------------------------------------------------

class RadioDialog : public DialogClass
{
public:

  char VariableName[50];
  char Prompter[50];
  char HotKeyDefine[30];
  char DerivedClass[50];
  char HelpLine[65];
  char RadioButtons[10][50];

  int GroupingCode;
  int HelpScreen;
  int SetForLiving;

  int Enabled;

	RadioDialog(int=0,int=0,int=0);

	int EventHandler(int);
  int GetRadio();
};

class ButtonDialog : public DialogClass
{
public:

  char RadioButtons[10][50];

	ButtonDialog();

	int EventHandler(int);
  int GetButtons();
};

//-------------------------------------------------------------------------
//
// Get the pick list information
//
//-------------------------------------------------------------------------

class PickDialog : public DialogClass
{
public:

  char Prompter[50];
  char HotKeyDefine[30];
  char DerivedClass[50];
  char HelpLine[65];

  int HelpScreen;
  int Width;
  int Height;

	PickDialog(int=0,int=0,int=0);

	int EventHandler(int);
  int GetPick();
};
