//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fli.h"
#include "elements.h"
#include "colors.h"
#include "fliwin.h"
#include "dds.h"

#include <string.h>

//-------------------------------------------------------------------------
//
// Dialog specifications and layout class
//
//-------------------------------------------------------------------------

const layoutContinue=10000;
const layoutCancel=10002;

class LayOutDialog : public DialogClass
{
public:

	LayOutDialog() : DialogClass(57,9,"Dialog Specifications") { }

	int EventHandler(int Event)
  {
    if (Event==kbEsc ||
        Event==kbCr ||
        Event==CloseEvent ||
        Event==OutsideEvent ||
        Event==layoutContinue ||
        Event==layoutCancel)
      return StopEvent;
    return CompleteEvent;
  }
};

//-------------------------------------------------------------------------
//
// Layout dialog construction
//
//-------------------------------------------------------------------------

void DialogWindow::LayOut()
{
  LayOutDialog &LayUp = *new LayOutDialog();

	char *DerivedSaved=new char[50];
	char *Saved=new char[50];
  if (Title)
	  strcpy(Saved,Title);
  else
    strcpy(Saved,"UnNamed Dialog");
  strcpy(DerivedSaved,DerivedClass);

	LayUp.Element(new DiaChar(14,1,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",Saved));
	LayUp.Help("Enter the title for this dialog box");
	LayUp.HotKey(1,1,"~Dialog Title",kbAltD);

	LayUp.Element(new DiaChar(15,3,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",DerivedSaved));
  LayUp.Help("The derived class name for this dialog box");
	LayUp.HotKey(1,3,"D~erived Class",kbAltE);

  LayUp.Element(new DiaPushButton(15,5,"Continue",layoutContinue,0,1));
	LayUp.Help("Accept this title and continue");

	LayUp.Element(new DiaPushButton(31,5,"Cancel",layoutCancel));
	LayUp.Help("Do not accept this title");

	int Save=LayUp.UseDialog();

	if (Save==kbCr || Save==layoutContinue)
  {
    if (Title)
      delete Title;
    Title=Saved;
    strcpy(DerivedClass,DerivedSaved);
  }

	delete DerivedSaved;
	delete &LayUp;
}
