//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "elements.h"
#include "mask.h"

const layoutContinue=30000;
const layoutCancel=30001;

//-------------------------------------------------------------------------
//
// Event handler for class that gets a heading
//
//-------------------------------------------------------------------------

int GroupDialog::EventHandler(int Event)
{
	if (Event==kbEsc ||
			Event==kbCr ||
			Event==CloseEvent ||
			Event==OutsideEvent ||
			Event==layoutContinue ||
			Event==layoutCancel)
		return StopEvent;
	return CompleteEvent;
}

//-------------------------------------------------------------------------
//
// Define/constructor group heading dialog
//
//-------------------------------------------------------------------------

GroupDialog::GroupDialog(int Gp) : DialogClass(57,9,"Group Heading Specifications")
{
  GroupText[0]=0;
  HotKeyDefine[0]=0;

  GroupingCode=Gp;

	Element(new DiaChar(15,1,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",GroupText));
	Help("Enter the text to describe this group of elements");
	HotKey(1,1,"~Group Heading",kbAltB);

	Element(new DiaChar(9,3,"xxxxxxxxxxxxxxxxxx",HotKeyDefine));
	Help("Enter the hot key #define to assign to this group heading");
	HotKey(1,3,"~Hot Key",kbAltH);

	Element(new DiaInt(49,3,"#####",GroupingCode));
	Help("Enter the group that this heading will coorespond to");
	HotKey(28,3,"~Cooresponds to Group",kbAltC);

  Element(new DiaPushButton(15,5,"Continue",layoutContinue,0,1));
	Help("Accept this title and continue");

  Element(new DiaPushButton(31,5,"Cancel",layoutCancel));
	Help("Do not accept this title");
}

//-------------------------------------------------------------------------
//
// Display and request information from user about the group heading
//
//-------------------------------------------------------------------------

int GroupDialog::GetGroup()
{
DoAgain:

	int Save=UseDialog();

	if (Save==kbCr || Save==layoutContinue)
  {
    if (!GroupText[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you must define the text"
        + "to describe the group!";

      NotValid.Title("Need a Description");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (!HotKeyDefine[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you MUST define a hot key"
        + "for this group.";

      NotValid.Title("Need a Hot Key");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (!GroupingCode)
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you MUST define the group"
        + "code to identify which group this"
        + "heading goes with.";

      NotValid.Title("Need a Group Code");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    return 1;
  }

  return 0;
}
