//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fliwin.h"
#include "colors.h"
#include "dds.h"

#include <stdio.h>
#include <alloc.h>
#include <mem.h>
#include <string.h>

//-------------------------------------------------------------------------
//
// Slide an element to the end of the dialog
//
//-------------------------------------------------------------------------

void DialogWindow::ManipToEnd()
{
  if (NumberPieces>1)
  {
    for (int i=NumberPieces-1;i>=0;i--)
    {
      PieceHandler &Piece=*Pieces[i];

      int PromptWidth=0;

      if (Piece.Prompter && *Piece.Prompter)
      {
        PromptWidth=strlen(Piece.Prompter)-(strchr(Piece.Prompter,'~')?1:0);
      }

      if ((CursorX>=Piece.X && CursorY>=Piece.Y &&
          CursorX<Piece.X+Piece.Width && CursorY<Piece.Y+Piece.Height &&
          Piece.LayOut>PieceHandler::__DUMMY__ && Piece.LayOut<PieceHandler::__DUMMY2__) ||
          (PromptWidth && CursorX>=Piece.PromptX &&
           CursorY>=Piece.PromptY &&
           CursorX<Piece.PromptX+PromptWidth &&
           CursorY==Piece.PromptY &&
           Piece.LayOut>PieceHandler::__DUMMY__ && Piece.LayOut<PieceHandler::__DUMMY2__))
      {
        RemoveTheMenus();

        if (i==NumberPieces-1)
           return;

        PieceHandler *Hold=Pieces[i];

        movmem(&Pieces[i+1],&Pieces[i],(NumberPieces-i-1)*sizeof(PieceHandler *));

        Pieces[NumberPieces-1]=Hold;

        VirtualizedInterior();

        return;
      }
    }
  }

  InfoBox NothingFound;

  NothingFound
    + "Sorry, there isn\'t an"
    + "element below the cursor that"
    + "can be moved to the end.";

  NothingFound.Title("Nothing to End");
  NothingFound.UseInfoBox();
}

//-------------------------------------------------------------------------
//
// Slide an element to the start of the dialog
//
//-------------------------------------------------------------------------

void DialogWindow::ManipToStart()
{
  if (NumberPieces>1)
  {
    for (int i=NumberPieces-1;i>=0;i--)
    {
      PieceHandler &Piece=*Pieces[i];

      int PromptWidth=0;

      if (Piece.Prompter && *Piece.Prompter)
      {
        PromptWidth=strlen(Piece.Prompter)-(strchr(Piece.Prompter,'~')?1:0);
      }

      if ((CursorX>=Piece.X && CursorY>=Piece.Y &&
          CursorX<Piece.X+Piece.Width && CursorY<Piece.Y+Piece.Height &&
          Piece.LayOut>PieceHandler::__DUMMY__ && Piece.LayOut<PieceHandler::__DUMMY2__) ||
          (PromptWidth && CursorX>=Piece.PromptX &&
           CursorY>=Piece.PromptY &&
           CursorX<Piece.PromptX+PromptWidth &&
           CursorY==Piece.PromptY &&
           Piece.LayOut>PieceHandler::__DUMMY__ && Piece.LayOut<PieceHandler::__DUMMY2__))
      {
        RemoveTheMenus();

        if (!i)
          return;

        PieceHandler *Hold=Pieces[i];

        movmem(&Pieces[0],&Pieces[1],i*sizeof(PieceHandler *));

        Pieces[0]=Hold;

        VirtualizedInterior();

        return;
      }
    }
  }

  InfoBox NothingFound;

  NothingFound
    + "Sorry, there isn\'t an"
    + "element below the cursor that"
    + "can be moved to the start.";

  NothingFound.Title("Nothing to Start");
  NothingFound.UseInfoBox();
}

//-------------------------------------------------------------------------
//
// Slide an element one step closer to the start of the dialog
//
//-------------------------------------------------------------------------

void DialogWindow::ManipEarlier()
{
  if (NumberPieces>1)
  {
    for (int i=NumberPieces-1;i>=0;i--)
    {
      PieceHandler &Piece=*Pieces[i];

      int PromptWidth=0;

      if (Piece.Prompter && *Piece.Prompter)
      {
        PromptWidth=strlen(Piece.Prompter)-(strchr(Piece.Prompter,'~')?1:0);
      }

      if ((CursorX>=Piece.X && CursorY>=Piece.Y &&
          CursorX<Piece.X+Piece.Width && CursorY<Piece.Y+Piece.Height &&
          Piece.LayOut>PieceHandler::__DUMMY__ && Piece.LayOut<PieceHandler::__DUMMY2__) ||
          (PromptWidth && CursorX>=Piece.PromptX &&
           CursorY>=Piece.PromptY &&
           CursorX<Piece.PromptX+PromptWidth &&
           CursorY==Piece.PromptY &&
           Piece.LayOut>PieceHandler::__DUMMY__ && Piece.LayOut<PieceHandler::__DUMMY2__))
      {
        RemoveTheMenus();

        if (!i)
          return;

        for (int j=i-1;j>=0;j--)
        {
          if (Pieces[j]->LayOut>PieceHandler::__DUMMY__ && Pieces[j]->LayOut<PieceHandler::__DUMMY2__)
          {
            PieceHandler *Hold=Pieces[i];

            movmem(&Pieces[i+1],&Pieces[i],(NumberPieces-i-1)*sizeof(PieceHandler *));

            movmem(&Pieces[j],&Pieces[j+1],(NumberPieces-j-1)*sizeof(PieceHandler *));

            Pieces[j]=Hold;

            VirtualizedInterior();

            return;
          }
        }

        return;
      }
    }
  }

  InfoBox NothingFound;

  NothingFound
    + "Sorry, there isn\'t an"
    + "element below the cursor that"
    + "can be moved closer to the"
    + "start of the dialog.";

  NothingFound.Title("Nothing to Early");
  NothingFound.UseInfoBox();
}

//-------------------------------------------------------------------------
//
// Slide an element one step closer to the end of the dialog
//
//-------------------------------------------------------------------------

void DialogWindow::ManipLater()
{
  if (NumberPieces>1)
  {
    for (int i=NumberPieces-1;i>=0;i--)
    {
      PieceHandler &Piece=*Pieces[i];

      int PromptWidth=0;

      if (Piece.Prompter && *Piece.Prompter)
      {
        PromptWidth=strlen(Piece.Prompter)-(strchr(Piece.Prompter,'~')?1:0);
      }

      if ((CursorX>=Piece.X && CursorY>=Piece.Y &&
          CursorX<Piece.X+Piece.Width && CursorY<Piece.Y+Piece.Height &&
          Piece.LayOut>PieceHandler::__DUMMY__ && Piece.LayOut<PieceHandler::__DUMMY2__) ||
          (PromptWidth && CursorX>=Piece.PromptX &&
           CursorY>=Piece.PromptY &&
           CursorX<Piece.PromptX+PromptWidth &&
           CursorY==Piece.PromptY &&
           Piece.LayOut>PieceHandler::__DUMMY__ && Piece.LayOut<PieceHandler::__DUMMY2__))
      {
        RemoveTheMenus();

        if (i==NumberPieces-1)
           return;

        for (int j=i+1;j<NumberPieces;j++)
        {
          if (Pieces[j]->LayOut>PieceHandler::__DUMMY__ && Pieces[j]->LayOut<PieceHandler::__DUMMY2__)
          {
            PieceHandler *Hold=Pieces[i];

            movmem(&Pieces[i+1],&Pieces[i],(NumberPieces-i-1)*sizeof(PieceHandler *));

            movmem(&Pieces[j],&Pieces[j+1],(NumberPieces-j-1)*sizeof(PieceHandler *));

            Pieces[j]=Hold;

            VirtualizedInterior();

            return;
          }
        }

        return;
      }
    }
  }

  InfoBox NothingFound;

  NothingFound
    + "Sorry, there isn\'t an"
    + "element below the cursor that"
    + "can be moved closer to the"
    + "end of the dialog.";

  NothingFound.Title("Nothing to Later");
  NothingFound.UseInfoBox();
}
