//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fliwin.h"
#include "elements.h"
#include "mask.h"
#include "dds.h"
#include "colors.h"

#include <alloc.h>
#include <string.h>

//-------------------------------------------------------------------------
//
// This edits an element (by selecting Manipulate|Size or Edit)
//
//-------------------------------------------------------------------------

void DialogWindow::EditElement(PieceHandler &Piece)
{
  MaskDialog *Mask=0;
  CheckDialog *CheckMask=0;
  PushDialog *PushMask=0;
  GroupDialog *GroupMask=0;
  RadioDialog *RadioMask=0;
  PickDialog *PickMask=0;

	switch (Piece.LayOut)
	{
		case PieceHandler::Character:
    case PieceHandler::Integer:
    case PieceHandler::Long:
    case PieceHandler::Float:
    case PieceHandler::Double:
    case PieceHandler::Bcd:
      Mask=new MaskDialog(Piece.GroupCode,Piece.HelpId,Piece.ToBeDerived);

      if (Piece.LayOut==PieceHandler::Character)
        Mask->CharacterActive=1;

      strcpy(Mask->ElementMask,Piece.Mask);
      strcpy(Mask->VariableName,Piece.Variable);
      strcpy(Mask->Prompter,Piece.Prompter);
      strcpy(Mask->HotKeyDefine,Piece.HotKey);
      strcpy(Mask->HelpLine,Piece.Help);
      strcpy(Mask->DerivedClass,Piece.DerivedClass);

      if (Piece.LayOut==PieceHandler::Character)
      {
        Mask->MaskCharacter[0]=Piece.MaskCharacter;
        Mask->MaskCharacter[1]=0;
        Mask->MaskWidth=Piece.MaskWidth;
        Mask->ScrollWidth=Piece.ScrollWidth;
      }

      if (Mask->GetMask())
        break;

      delete Mask;
			return;

		case PieceHandler::Check:
      CheckMask=new CheckDialog(Piece.GroupCode,Piece.HelpId,Piece.ToBeDerived);

      strcpy(CheckMask->CheckText,Piece.Text);
      strcpy(CheckMask->HotKeyDefine,Piece.HotKey);
      strcpy(CheckMask->VariableName,Piece.Variable);
      strcpy(CheckMask->HelpLine,Piece.Help);
      strcpy(CheckMask->DerivedClass,Piece.DerivedClass);

      if (CheckMask->GetCheck())
      {
        Piece.Width=strlen(CheckMask->CheckText)+2;
        if (strchr(CheckMask->CheckText,'~'))
          Piece.Width--;
        break;
      }

      delete CheckMask;
			return;

		case PieceHandler::Push:
      PushMask=new PushDialog(Piece.GroupCode,Piece.HelpId,Piece.ToBeDerived);

      strcpy(PushMask->PushText,Piece.Text);
      strcpy(PushMask->Constant,Piece.Constant);
      strcpy(PushMask->HotKeyDefine,Piece.HotKey);
      strcpy(PushMask->HelpLine,Piece.Help);
      strcpy(PushMask->DerivedClass,Piece.DerivedClass);

      if (PushMask->GetPush())
      {
        Piece.Width=strlen(PushMask->PushText)+2;
        if (strchr(PushMask->PushText,'~'))
          Piece.Width--;
        break;
      }

      delete PushMask;
			return;

		case PieceHandler::GroupHeading:
      GroupMask=new GroupDialog(Piece.GroupCode);

      strcpy(GroupMask->GroupText,Piece.Text);
      strcpy(GroupMask->HotKeyDefine,Piece.HotKey);

      if (GroupMask->GetGroup())
      {
        Piece.Width=strlen(GroupMask->GroupText);
        if (strchr(GroupMask->GroupText,'~'))
          Piece.Width--;
        break;
      }

      delete GroupMask;
			return;

    case PieceHandler::HRadio:
    case PieceHandler::VRadio:
      RadioMask=new RadioDialog(Piece.GroupCode,Piece.HelpId,Piece.ToBeDerived);
      if (Piece.LayOut==PieceHandler::HRadio)
        RadioMask->Enabled=1;

      for (int i=0;i<10;i++)
        strcpy(RadioMask->RadioButtons[i],Piece.Elements[i]);

      strcpy(RadioMask->VariableName,Piece.Variable);
      strcpy(RadioMask->Prompter,Piece.Prompter);
      strcpy(RadioMask->HotKeyDefine,Piece.HotKey);
      strcpy(RadioMask->HelpLine,Piece.Help);
      strcpy(RadioMask->DerivedClass,Piece.DerivedClass);

      if (RadioMask->GetRadio())
        break;

      delete RadioMask;
			return;

    case PieceHandler::PickGeneric:
      PickMask=new PickDialog(Piece.HelpId,Piece.Width-3,Piece.Height);

      strcpy(PickMask->Prompter,Piece.Prompter);
      strcpy(PickMask->HotKeyDefine,Piece.HotKey);
      strcpy(PickMask->HelpLine,Piece.Help);
      strcpy(PickMask->DerivedClass,Piece.DerivedClass);

      if (PickMask->GetPick())
        break;

      delete PickMask;
			return;

	}

  if (Piece.LayOut==PieceHandler::HRadio)
  {
    for (int i=0,j=1;i<10;i++)
    {
      if (!RadioMask->RadioButtons[i][0])
        continue;
      j+=(strlen(RadioMask->RadioButtons[i])+5);
    }
    Piece.Width=j;
  }

  if (Piece.LayOut==PieceHandler::VRadio)
  {
    for (int i=0,j=0,k=0;i<10;i++)
    {
      if (!RadioMask->RadioButtons[i][0])
        continue;
      k++;
      if ((strlen(RadioMask->RadioButtons[i])+6)>j)
        j=strlen(RadioMask->RadioButtons[i])+6;
    }
    Piece.Height=k;
    Piece.Width=j;
  }

  if (Mask)
  {

    strcpy(Piece.Mask,Mask->ElementMask);
    strcpy(Piece.Variable,Mask->VariableName);
    strcpy(Piece.Prompter,Mask->Prompter);
    strcpy(Piece.HotKey,Mask->HotKeyDefine);
    strcpy(Piece.Help,Mask->HelpLine);
    strcpy(Piece.DerivedClass,Mask->DerivedClass);

    Piece.GroupCode=Mask->GroupingCode;
    Piece.HelpId=Mask->HelpScreen;
    Piece.ToBeDerived=Mask->SetForLiving;

    Piece.MaskCharacter=Mask->MaskCharacter[0];
    Piece.MaskWidth=Mask->MaskWidth;
    Piece.ScrollWidth=Mask->ScrollWidth;

    if (Piece.ScrollWidth)
      Piece.Width=Piece.ScrollWidth+2;
    else if (Piece.MaskWidth)
      Piece.Width=Piece.MaskWidth;
    else
      Piece.Width=strlen(Piece.Mask);

    delete Mask;

  }

  if (CheckMask)
  {

    strcpy(Piece.Text,CheckMask->CheckText);
    strcpy(Piece.HotKey,CheckMask->HotKeyDefine);
    strcpy(Piece.Variable,CheckMask->VariableName);
    strcpy(Piece.Help,CheckMask->HelpLine);
    strcpy(Piece.DerivedClass,CheckMask->DerivedClass);

    Piece.GroupCode=CheckMask->GroupingCode;
    Piece.HelpId=CheckMask->HelpScreen;
    Piece.ToBeDerived=CheckMask->SetForLiving;

    delete CheckMask;

  }

  if (PushMask)
  {

    strcpy(Piece.Text,PushMask->PushText);
    strcpy(Piece.Constant,PushMask->Constant);
    strcpy(Piece.HotKey,PushMask->HotKeyDefine);
    strcpy(Piece.Help,PushMask->HelpLine);
    strcpy(Piece.DerivedClass,PushMask->DerivedClass);

    Piece.GroupCode=PushMask->GroupingCode;
    Piece.HelpId=PushMask->HelpScreen;
    Piece.ToBeDerived=PushMask->SetForLiving;

    delete PushMask;

  }

  if (GroupMask)
  {

    strcpy(Piece.Text,GroupMask->GroupText);
    strcpy(Piece.HotKey,GroupMask->HotKeyDefine);

    Piece.GroupCode=GroupMask->GroupingCode;

    delete GroupMask;

  }

  if (RadioMask)
  {

    strcpy(Piece.Variable,RadioMask->VariableName);
    strcpy(Piece.Prompter,RadioMask->Prompter);
    strcpy(Piece.HotKey,RadioMask->HotKeyDefine);
    strcpy(Piece.Help,RadioMask->HelpLine);
    strcpy(Piece.DerivedClass,RadioMask->DerivedClass);

    Piece.GroupCode=RadioMask->GroupingCode;
    Piece.HelpId=RadioMask->HelpScreen;
    Piece.ToBeDerived=RadioMask->SetForLiving;

    for (int i=0;i<10;i++)
      strcpy(Piece.Elements[i],RadioMask->RadioButtons[i]);

    delete RadioMask;

  }

  if (PickMask)
  {

    strcpy(Piece.Prompter,PickMask->Prompter);
    strcpy(Piece.HotKey,PickMask->HotKeyDefine);
    strcpy(Piece.Help,PickMask->HelpLine);
    strcpy(Piece.DerivedClass,PickMask->DerivedClass);

    Piece.HelpId=PickMask->HelpScreen;
    Piece.ToBeDerived=1;

    Piece.Height=PickMask->Height;
    Piece.Width=PickMask->Width+3;

    delete PickMask;

  }

  RemoveTheMenus();

  VirtualizedInterior();
}
