//
// The Fusion Library Interface for DOS
// Version 1.01
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "piece.h"

//-------------------------------------------------------------------------
//
// Event codes for menu items
//
//-------------------------------------------------------------------------

const winOpen=5000;
const winNew=5001;
const winSave=5002;
const winSaveAs=5003;
const winChDir=5004;
const winGenCPP=5005;
const winDOSShell=5006;
const winExit=5007;
const winControlPanel=5008;
const winAbout=5009;

const winCallMenu=5010;

// LAYOUT menu

const layoutSpecs=5050;
const layoutEditMode=5051;
const layoutMove=5052;
const layoutSize=5053;
const layoutZoom=5054;
const layoutTest=5055;

// DRAW menu

const drawBox=5100;
const drawFillBox=5101;
const drawHLine=5102;
const drawVLine=5103;
const drawCharBox=5104;
const drawShadow=5105;
const drawErase=5106;
const drawTrans=5107;
const drawPlop=5108;
const drawColor=5109;

// ELEMENT menu

const entryMenu=5195; // to provide help for sub menu
const radioMenu=5196; // to provide help for sub menu
const elementChar=5200;
const elementInt=5201;
const elementLong=5202;
const elementFloat=5203;
const elementDouble=5204;
const elementBcd=5205;
const elementVRadio=5206;
const elementHRadio=5207;
const elementPick=5208;
const elementCheck=5209;
const elementPush=5210;
const elementHeading=5211;
const elementScrollChar=5212;
const elementPickStruct=5213;
const elementPickArray=5214;
const elementPickGeneric=5215;

// MANIPULATE menu

const manipBack=5300;
const manipForward=5301;
const manipReArrange=5302;
const manipGroupings=5303;
const manipSize=5304;
const manipMove=5305;
const manipMoveText=5306;
const manipCopy=5307;
const manipCopyText=5308;
const manipDeletePiece=5309;
const manipTextColor=5310;
const manipObjectColor=5311;
const manipTestDialog=5312;
const manipToStart=5313;
const manipToEnd=5314;
const manipEarlier=5315;
const manipLater=5316;

//-------------------------------------------------------------------------
//
// Event codes for dialogs
//
//-------------------------------------------------------------------------

// Events for control panel

const panelAcceptButton=10000;
const panelColorButton=10014;
const panelVideoButton=10015;
const videoChange=10016;
const videoCancel=10017;
const colorChange=10018;
const colorCancel=10019;

// Events for ChDir dialog

const ChDirCancelButton=10100;
const ChDirRevertButton=10101;
const ChDirOkayButton=10102;

//-------------------------------------------------------------------------
//
// ZPositioning status variable and "About.." box global variable
//
//-------------------------------------------------------------------------

extern InfoBox *Welcome;
extern int ZPositioning;

//-------------------------------------------------------------------------
//
// Main dialog window - derived class
//
//-------------------------------------------------------------------------

class DialogWindow : public WindowElement
{
public:

  char FileName[100];

private:

  int CurrentColor;                 // Current drawing color

  int CursorX, CursorY;             // Current cursor location

  int Insert;                       // Status of insert mode toggle

  char (*Interior)[400];            // Text storage for interior of window

  PieceHandler **Pieces;            // Storage for defined objects/elements
  int NumberPieces;                 // Total number of defined pieces

  int PreviousWidth;                // Storage for previous dimensions of
  int PreviousHeight;               // an altered object

  char DerivedClass[50];            // The name of the derived class

  int PlopCharacter();
  int GetMaskElement();
  int MoveObject(int=0,int=0);

  void ChangeColor();
	void Generate(char *GenTo);
	void PlaceObject(int);
	void PlaceElement(int);
	void VirtualizedInterior();
	void MoveText();
	void ColorObject();
	void ColorText();
	void CopyObject();
	void CopyText();
	void DeleteObject();
	void SizeObject(int=0);
	void PushBack();
	void BringFront();
	void ManipToStart();
  void ManipToEnd();
  void ManipEarlier();
  void ManipLater();
	void Groupings();
	void LayOut();
  void PlacePrompter(PieceHandler &);
  void EditElement(PieceHandler &);
  void TestDialog();
  void SaveFile(char *);

public:

  void LoadFile(char *LoadIt);

	void ShowInterior();
  void ShowWindow();
  void Cursor();

  int EventHandler(int Event);

  DialogWindow(char *LoadIt=0);
	~DialogWindow();
};

//-------------------------------------------------------------------------
//
// Event handler/dispatcher definition for FusionWindow and this program
//
//-------------------------------------------------------------------------

class DesignerWindow : public FusionWindow
{
  int ControlPanel();
  void ChDir();

  int EventHandler(int Event);
};

//-------------------------------------------------------------------------
//
// Elements for the colorization dialog
//
//-------------------------------------------------------------------------

struct CurrentColor
{
  static int *TheColor;
};

class ForeGround : public DialogElement, public CurrentColor
{
private:

  int TestX, TestY;

public:

  ForeGround(int X,int Y,int TestX,int TestY);
  void Show();
  void HighLight();
  int EventHandler(int Event);
};

class BackGround : public DialogElement, public CurrentColor
{
private:

  int TestX, TestY;

public:

  BackGround(int X,int Y,int TestX,int TestY);
	void Show();
  void HighLight();
	int EventHandler(int Event);
};
