//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fli.h"
#include "piece.h"

//-------------------------------------------------------------------------
//
// Destruction of all declared and allocated pointers
//
//-------------------------------------------------------------------------

PieceHandler::~PieceHandler()
{
  if (Mask)
    delete Mask;

  if (Variable)
    delete Variable;

  if (Prompter)
    delete Prompter;

  if (HotKey)
    delete HotKey;

  if (Text)
    delete Text;

  if (Constant)
    delete Constant;

  if (Help)
    delete Help;

  if (DerivedClass)
    delete DerivedClass;

  if (Elements)
  {
    for (int i=0;i<10;i++)
      delete Elements[i];
    delete Elements;
  }
}

//-------------------------------------------------------------------------
//
// Sizing function for objects (not elements).  It is declared as
// a null function to eliminate overhead with elements -- since they
// do not need the function to operate.
//
//-------------------------------------------------------------------------

void PieceHandler::Size(int X,int Y)
{
  // Empty function to conserve space
}

//-------------------------------------------------------------------------
//
// Define the constructors for the objects
//
//-------------------------------------------------------------------------

#undef Fig

#define Fig(A) \
A::A(BlazeClass *_Blaze_,int X,int Y,int Width,int Height,int Color) : \
  PieceHandler(_Blaze_) \
  { \
    LayOut=A; \
    PieceHandler::X=X; \
    PieceHandler::Y=Y; \
    PieceHandler::Width=Width; \
    PieceHandler::Height=Height; \
    PieceHandler::Color=Color; \
    Mask=0; \
    Elements=0; \
    Variable=0; \
    Prompter=0; \
    GroupCode=0; \
    HelpId=0; \
    ToBeDerived=0; \
    PromptX=0; \
    PromptY=0; \
    Text=0; \
    Constant=0; \
    HotKey=0; \
    Help=0; \
    DerivedClass=0; \
    MaskCharacter=0; \
    MaskWidth=0; \
    ScrollWidth=0; \
    Focus_Reset=0; \
  } \
A::A(PieceHandler &Object) \
  { \
    LayOut=A; \
    X=Object.X; \
    Y=Object.Y; \
    Width=Object.Width; \
    Height=Object.Height; \
    Color=Object.Color; \
    Mask=Object.Mask; \
    Elements=Object.Elements; \
    Blaze=Object.Blaze; \
    Variable=Object.Variable; \
    Prompter=Object.Prompter; \
    GroupCode=Object.GroupCode; \
    HelpId=Object.HelpId; \
    ToBeDerived=Object.ToBeDerived; \
    PromptX=Object.PromptX; \
    PromptY=Object.PromptY; \
    Text=Object.Text; \
    Constant=Object.Constant; \
    HotKey=Object.HotKey; \
    Help=Object.Help; \
    DerivedClass=Object.DerivedClass; \
    MaskCharacter=Object.MaskCharacter; \
    MaskWidth=Object.MaskWidth; \
    ScrollWidth=Object.ScrollWidth; \
    Focus_Reset=Object.Focus_Reset; \
  } \

Fig(Box);
Fig(FilledBox);
Fig(HorizontalLine);
Fig(VerticalLine);
Fig(Shadow);
Fig(EraseArea);
Fig(ColorizeArea);
Fig(Character);
Fig(Integer);
Fig(Long);
Fig(Float);
Fig(Double);
Fig(Bcd);
Fig(VRadio);
Fig(HRadio);
Fig(Check);
Fig(Push);
Fig(GroupHeading);
Fig(PickGeneric);
