//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fli.h"
#include "elements.h"
#include "colors.h"
#include "fliwin.h"
#include "dds.h"

//-------------------------------------------------------------------------
//
// Defines the current color for an object
//
//-------------------------------------------------------------------------

int *CurrentColor::TheColor=0;

//-------------------------------------------------------------------------
//
// Foreground color class element
//
//-------------------------------------------------------------------------

ForeGround::ForeGround(int X,int Y,int TestX,int TestY)
{
	DialogElement::X=X;
	DialogElement::Y=Y;
	ForeGround::TestX=TestX;
	ForeGround::TestY=TestY;
	Width=12;
	Height=4;
}

void ForeGround::Show()
{
	MouseHide();
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			(*Blaze)(X+(j*3),Y+i) << (int)((i*4)+j) << "\xdb\xdb\xdb";
	(*Blaze)(TestX,TestY) << *TheColor << "  Current!  ";
	int Color=*TheColor&15; // Masks out other colors
	int Y=(Color)?(Color/4):0;
	int X=(Color-(Y*4))*3;
	(*Blaze)(DialogElement::X+X,DialogElement::Y+Y) << Color << "\xfe\xfe\xfe";
	(*Blaze) << Colors.DiaInterior;
	Blaze->CharacterRepeater(DialogElement::X,DialogElement::Y-1,12,Colors.DiaInterior,' ');
	Blaze->CharacterRepeaterDown(DialogElement::X-1,DialogElement::Y,4,Colors.DiaInterior,' ');
	(*Blaze) (DialogElement::X-1,DialogElement::Y+Y) << '\x7';
	(*Blaze) (DialogElement::X+X+1,DialogElement::Y-1) << '\x7';
	MouseShow();
}

void ForeGround::HighLight()
{
	MouseHide();
	int Color=*TheColor&15; // Masks out other colors
	int Y=(Color)?(Color/4):0;
	int X=(Color-(Y*4))*3;
	(*Blaze)(DialogElement::X+X,DialogElement::Y+Y) << (Color|128) << "\xfe\xfe\xfe";
	Blaze->WindowGotoXY(DialogElement::X+X+1,DialogElement::Y+Y);
	MouseShow();
}

int ForeGround::EventHandler(int Event)
{
	int Color=*TheColor&15; // Masks out other colors
	int Y=(Color)?(Color/4):0;
	int X=(Color-(Y*4));

	if (Event==kbRight)
	{
		if (X<3)
			(*TheColor)++;
		else
			(*TheColor)-=3;
		Show();
		HighLight();
		return CompleteEvent;
	}

	if (Event==kbLeft)
	{
		if (!X)
			(*TheColor)+=3;
		else
			(*TheColor)--;
		Show();
		HighLight();
		return CompleteEvent;
	}

	if (Event==kbDown)
	{
		if (Y<3)
			(*TheColor)+=4;
		else
			(*TheColor)-=12;
		Show();
		HighLight();
		return CompleteEvent;
	}

	if (Event==kbUp)
	{
		if (!Y)
			(*TheColor)+=12;
		else
			(*TheColor)-=4;
		Show();
		HighLight();
		return CompleteEvent;
	}

	if (Event==ValidatedMousedEvent &&
		(MouseEvent&MouseLeftButtonRelease || MouseButtonStatus&LeftButton))
	{
		MouseHorizontal-=DialogElement::X;
		MouseVertical-=DialogElement::Y;
		int X=(MouseHorizontal)?(MouseHorizontal/3):0;
		int Color=(MouseVertical*4)+X;
		*TheColor=(*TheColor&240)+Color;
		Show();
		HighLight();
		return CompleteEvent;
	}

	return Event;
}

//-------------------------------------------------------------------------
//
// Foreground color class element
//
//-------------------------------------------------------------------------

BackGround::BackGround(int X,int Y,int TestX,int TestY)
{
	DialogElement::X=X;
	DialogElement::Y=Y;
	BackGround::TestX=TestX;
	BackGround::TestY=TestY;
	Width=12;
	Height=2;
}

void BackGround::Show()
{
	MouseHide();
	int Colored[] = { bBlack,bBlue,bGreen,bCyan,bRed,bMagenta,bBrown,bWhite };
	for (int i=0;i<2;i++)
		for (int j=0;j<4;j++)
      (*Blaze)(X+(j*3),Y+i) << Colored[(i*4)+j] << "   ";
  (*Blaze)(TestX,TestY) << *TheColor << "  Current!  ";
  int Color=(*TheColor&112)>>4; // Masks out other colors
  int Y=(Color)?(Color/4):0;
  int X=(Color-(Y*4))*3;
  (*Blaze)(DialogElement::X+X,DialogElement::Y+Y) << Color << "\xfe\xfe\xfe";
  (*Blaze) << Colors.DiaInterior;
  Blaze->CharacterRepeater(DialogElement::X,DialogElement::Y-1,12,Colors.DiaInterior,' ');
  Blaze->CharacterRepeaterDown(DialogElement::X-1,DialogElement::Y,2,Colors.DiaInterior,' ');
  (*Blaze) (DialogElement::X-1,DialogElement::Y+Y) << '\x7';
  (*Blaze) (DialogElement::X+X+1,DialogElement::Y-1) << '\x7';
  MouseShow();
}

void BackGround::HighLight()
{
  MouseHide();
  int Color=(*TheColor&112)>>4; // Masks out other colors
  int Y=(Color)?(Color/4):0;
  int X=(Color-(Y*4))*3;
  (*Blaze)(DialogElement::X+X,DialogElement::Y+Y) << (Color|128) << "\xfe\xfe\xfe";
  Blaze->WindowGotoXY(DialogElement::X+X+1,DialogElement::Y+Y);
  MouseShow();
}

int BackGround::EventHandler(int Event)
{
	int Color=(*TheColor&112)>>4; // Masks out other colors
  int Y=(Color)?(Color/4):0;
	int X=(Color-(Y*4));

  if (Event==kbRight)
  {
    if (X<3)
      Color++;
    else
      Color=3;
    *TheColor=(*TheColor&143)+(Color<<4);
    Show();
    HighLight();
    return CompleteEvent;
  }

  if (Event==kbLeft)
  {
    if (!X)
      Color+=3;
    else
      Color--;
    *TheColor=(*TheColor&143)+(Color<<4);
    Show();
    HighLight();
    return CompleteEvent;
  }

  if (Event==kbDown)
  {
    if (Y<1)
      Color+=4;
    else
      Color-=4;
		*TheColor=(*TheColor&143)+(Color<<4);
    Show();
		HighLight();
    return CompleteEvent;
  }

  if (Event==kbUp)
  {
    if (!Y)
      Color+=4;
    else
      Color-=4;
    *TheColor=(*TheColor&143)+(Color<<4);
    Show();
    HighLight();
    return CompleteEvent;
  }

  if (Event==ValidatedMousedEvent &&
    (MouseEvent&MouseLeftButtonRelease || MouseButtonStatus&LeftButton))
  {
    MouseHorizontal-=DialogElement::X;
    MouseVertical-=DialogElement::Y;
    int X=(MouseHorizontal)?(MouseHorizontal/3):0;
    int Color=(MouseVertical*4)+X;
    *TheColor=(*TheColor&143)+(Color<<4);
    Show();
    HighLight();
    return CompleteEvent;
  }

  return Event;
}

//-------------------------------------------------------------------------
//
// Color changing dialog
//
//-------------------------------------------------------------------------

class ChColorDialog : public DialogClass
{
public:

  ChColorDialog() : DialogClass(20,20,"Palette")
    {  }

  int EventHandler(int Event)
  {
    if (Event==kbEsc ||
        Event==kbCr ||
        Event==CloseEvent ||
        Event==OutsideEvent ||
        Event==colorChange ||
        Event==colorCancel)
      return StopEvent;
    return CompleteEvent;
  }
};

//-------------------------------------------------------------------------
//
// Change colors / display dialog
//
//-------------------------------------------------------------------------

void DialogWindow::ChangeColor()
{
	ChColorDialog &Dialog=*new ChColorDialog();

	int Color=CurrentColor;
	CurrentColor::TheColor=&Color;

	Dialog.Element(new ForeGround(3,3,3,14));
	Dialog.HotKey(4,1,"~Foreground",kbAltF);
	Dialog.Help("Select this foreground palette color");

	Dialog.Element(new BackGround(3,10,3,14));
	Dialog.HotKey(4,8,"~Background",kbAltB);
	Dialog.Help("Select this background palette color");

  Dialog.Element(new DiaPushButton(1,16,"Ok",colorChange,0,1));
	Dialog.Help("Change to this palette color");

	Dialog.Element(new DiaPushButton(8,16,"Cancel",colorCancel));
	Dialog.Help("Do not change the color");

	Dialog.Blaze.Box(1,1,16,7,Colors.DiaInterior);
	Dialog.Blaze.Box(1,8,16,5,Colors.DiaInterior);
	Dialog.Blaze.UserBoxDefineQuick(2);
	Dialog.Blaze.Box(1,13,16,3,Colors.DiaInterior);
	Dialog.Blaze.UserBoxDefineQuick(1);
	Dialog.Blaze (6,13) << Colors.DiaInterior << "Sample";

	int Remember=Dialog.UseDialog();
  delete &Dialog;

	if (Remember==kbCr || Remember==colorChange)
  {
		CurrentColor=Color;

    BlazeClass Blaze;

    RemoveTheMenus();

    Blaze (X+2,Y+Height-1) << CurrentColor << "Color";
  }
}

