//
// The Fusion Library Interface for DOS
// Version 1.01
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//
//
// To use this dialog in your own program, here is all you have to do:
//
//   1. Include CHGDIR.H in your module
//   2. Place the following code where you want to bring up the dialog:
//         ChDirDialog &ChDir=*new ChDirDialog();
//         ChDir.UseDialog();
//         delete &ChDir;
//   3. That is it!!
//

#include "elements.h"
#include <dir.h>

//-------------------------------------------------------------------------
//
// PathStorage element that stores path information
//
//-------------------------------------------------------------------------

#define MaxEntries 100

class PathStorage
{
public:

  char *Revert;
  char *Path;
  ffblk *DirEntries;
  char (*Drives)[2];
  int Count;
  int DriveCount;
  int CurrentDisk;
  int SaveDisk;

  PathStorage();
  ~PathStorage();

  void Refresh();
};

//-------------------------------------------------------------------------
//
// ChDirDialog class that controls the entire dialog
//
//-------------------------------------------------------------------------

class ChDirDialog : public DialogClass
{
public:

  PathStorage *Path;

  ChDirDialog();
  ~ChDirDialog();

  int EventHandler(int Event);
};

//-------------------------------------------------------------------------
//
// ChDirPath class that handles the dir path
//
//-------------------------------------------------------------------------

class ChDirPath : public DiaChar
{
public:

  PathStorage &Path;
  char *ComparePathStorage;

  ChDirPath(int X,int Y,PathStorage &_Path);
  ~ChDirPath();

  int EventHandler(int Event);
};

//-------------------------------------------------------------------------
//
// ChDirList class that lists the available directories
//
//-------------------------------------------------------------------------

class ChDirList : public DiaStructPickList
{
public:

  PathStorage &Path;
  static int CurrentItem;

  ChDirList(int X,int Y,PathStorage &_Path);

  int EventHandler(int Event);
  void Show();
};

//-------------------------------------------------------------------------
//
// DirList class that lists all of the available drives
//
//-------------------------------------------------------------------------

class DirList : public DiaStructPickList
{
public:

  PathStorage &Path;

  DirList(int X,int Y,PathStorage &_Path);

  int EventHandler(int Event);
};

//-------------------------------------------------------------------------
//
// Prompt class indiciates current location
//
//-------------------------------------------------------------------------

class Prompt : public DialogElement
{
public:

  PathStorage &Path;

  Prompt(PathStorage &_Path);

  void Show();
  void HighLight();
  int Available();
  int EventHandler(int Event);
};
