//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "elements.h"
#include "mask.h"
#include "colors.h"

const layoutContinue=30000;
const layoutCancel=30001;

//-------------------------------------------------------------------------
//
// Dialog that gets information about a check box
//
//-------------------------------------------------------------------------

int CheckDialog::EventHandler(int Event)
{
	if (Event==kbEsc ||
			Event==kbCr ||
			Event==CloseEvent ||
			Event==OutsideEvent ||
			Event==layoutContinue ||
			Event==layoutCancel)
		return StopEvent;
	return CompleteEvent;
}

//-------------------------------------------------------------------------
//
// Construct the dialog that gets information about a check box
//
//-------------------------------------------------------------------------

CheckDialog::CheckDialog(int Gp,int Hs,int Sl) :
  DialogClass(78,19,"Check Box Specifications")
{
  CheckText[0]=0;
  VariableName[0]=0;
  HotKeyDefine[0]=0;
  HelpLine[0]=0;
  DerivedClass[0]=0;

  GroupingCode=Gp;
  HelpScreen=Hs;
  SetForLiving=Sl;

  Blaze.Box(1,1,57,7,Colors.DiaInterior);
  Blaze.Box(1,8,57,5,Colors.DiaInterior);
  Blaze.Box(1,13,74,3,Colors.DiaInterior);

  GroupHeading(18,1,1,"Element ~Characteristics",kbAltC);
  GroupHeading(18,8,2,"~Derivision Characteristics",kbAltD);
  GroupHeading(30,13,3,"Help/Prompt ~Line",kbAltL);

	GroupElement(1,new DiaChar(18,2,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",CheckText));
	Help("Enter the text to place next to the check box");
	HotKey(3,2,"~Check Box Text",kbAltC);

	GroupElement(1,new DiaChar(12,4,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",VariableName));
	Help("Enter the variable name that this element will be placed into");
	HotKey(3,4,"~Variable",kbAltV);

	GroupElement(1,new DiaChar(11,6,"xxxxxxxxxxxxx",HotKeyDefine));
	Help("Enter the hot key #define to assign to this element");
	HotKey(3,6,"~Hot Key",kbAltH);

	GroupElement(1,new DiaInt(39,6,"###",GroupingCode));
	Help("Enter the group to assign this element to (0 for none)");
	HotKey(25,6,"~Grouping Code",kbAltG);

	GroupElement(1,new DiaInt(51,6,"#####",HelpScreen));
	Help("Enter the help screen for this element (0 for none)");
	HotKey(43,6,"~Help Id",kbAltG);

  GroupElement(2,new DiaHorizRadio(17,9,SetForLiving,0,0));
  (*this) + "Do Not Derive!" + "Derive a Class";
  Help("Should a derived class be created for this element?");
  HotKey(3,9,"~Derived Class",kbAltD);

	GroupElement(2,new DiaChar(19,11,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",DerivedClass));
	Help("Enter the name of the derived class");
	HotKey(3,11,"~Name of Derived",kbAltN);

	GroupElement(3,new DiaChar(13,14,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",HelpLine));
	Help("Help that you would like to appear at the bottom of the screen");
	HotKey(3,14,"Help ~Line",kbAltL);

  Element(new DiaPushButton(62,5,"Continue",layoutContinue,0,1));
	Help("Accept this title and continue");

  Element(new DiaPushButton(63,8,"Cancel",layoutCancel));
	Help("Do not accept this title");
}

//-------------------------------------------------------------------------
//
// Request information about the check box
//
//-------------------------------------------------------------------------

int CheckDialog::GetCheck()
{
DoAgain:

	int Save=UseDialog();

	if (Save==kbCr || Save==layoutContinue)
  {
    if (!CheckText[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you must define the text"
        + "to describe the check box!";

      NotValid.Title("Need a Description");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (!VariableName[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you must define a variable"
        + "name.  This variable name signifies"
        + "where you would like the input"
        + "from this element to go.";

      NotValid.Title("Need a Variable");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (HelpScreen && (HelpScreen<1000 || HelpScreen>32000))
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, the help screen that you"
        + "specified is invalid.  It must"
        + "be between 1000 and 32000.";

      NotValid.Title("Incorrect Help");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (SetForLiving && !DerivedClass[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, a name for the derived"
        + "class must be specified.";

      NotValid.Title("Missing Derived");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    return 1;
  }

  return 0;
}
