//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
//

#include "fli.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ShowElements()
//
// Show the elements
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DialogClass::ShowElements(int Here)
{
  Blaze.InvisibleCursor();

  DialogElement *Redraw=First;

  do
  {
    if (!Here || (Here && Redraw!=Present))
    {
      Redraw->Show();
      MouseHide();
      if (Redraw->LocatorText && !AlreadyShown)
        Blaze.QuickDisplay(Redraw->LocX,Redraw->LocY,
          (Redraw->Available()!=FailedEvent)?
            Colors.DiaQuickKey:Colors.DiaDeadLocator,
          (Redraw->Available()!=FailedEvent)?
            Colors.DiaLocator:Colors.DiaDeadLocator,Redraw->LocatorText);
      MouseShow();
    }
    Redraw=Redraw->Next;
  }
  while (Redraw);

  AlreadyShown=1;

  Blaze.VisibleCursor();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ShowDialogBox()
//
// Show the dialog box
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DialogClass::ShowDialogBox()
{
   BlazeClass Blaze;

   MouseHide();
   Blaze.Window(X,Y,Width,Height);

   Blaze.Box(0,0,Width,Height,Colors.DiaBorder);

   if (CloseIcon)
     Blaze (1,0) << Colors.DiaBorder << '['
       << Colors.DiaCloseIcon << '\x7'
       << Colors.DiaBorder << ']';

   int Icon=(CloseIcon)?0:4;

   if (TopTitle && strlen(TopTitle)<=((Width-6)+Icon))
     Blaze (5-Icon,0) << Colors.DiaTitle << TopTitle;

   MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ShowLocator()
//
// Show the locator
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DialogClass::ShowLocator(int Visible)
{
  MouseHide();
  if (Present->LocatorText)
    Blaze.QuickDisplay(Present->LocX,Present->LocY,
      (Visible)?Colors.DiaHiLiteLocator:
        ((Present->Available()!=FailedEvent)?Colors.DiaQuickKey:Colors.DiaDeadLocator),
      (Visible)?Colors.DiaHiLiteLocator:
        ((Present->Available()!=FailedEvent)?Colors.DiaLocator:Colors.DiaDeadLocator),
      Present->LocatorText);

  if (Visible)
    Blaze.HelpLine(Present->FusionHelp,Present->Help);
  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ShowHeading()
//
// Show the heading locator
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DialogClass::ShowHeading(int Visible)
{
  if (!HeadingCount)
    return;

  MouseHide();

  for (int i=0;i<HeadingCount;i++)
  {
    _GroupHeadings &Head=*(HeadingStorage+i);

    if (!Visible)
      Blaze.QuickDisplay(Head.X,Head.Y,Colors.DiaHeadingQuickKey,
        Colors.DiaHeading,Head.Heading);
    else if (Head.GroupCode==Visible)
      Blaze.QuickDisplay(Head.X,Head.Y,Colors.DiaHiLiteHeading,
        Colors.DiaHiLiteHeading,Head.Heading);
  }

  MouseShow();
}

