//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
//

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// RePosition()
//
// Repositions to specified element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::RePosition(DialogElement *LocationToGo)
{
  if (LocationToGo->Available()==FailedEvent)
    return 0;

  Present->Show();

  int SaveGroup=Present->GroupCode;

  ShowLocator(0);
  LastPresent=0;

  Present=LocationToGo;

  if (SaveGroup!=Present->GroupCode)
    ShowHeading(0);
  ShowHeading(Present->GroupCode);
  ShowLocator();

  Blaze.VisibleCursor();
  Present->HighLight();

  return 1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Depart()
//
// Departs from the current element and calls the departure function
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::Depart(DialogElement &Present)
{
  DialogElement *Save=DialogClass::Present;
  DialogClass::Present=&Present;

  Present.Show();
  ShowLocator(0);

  DialogClass::Present=Save;

  int Test=Present.Departure();

  if (Test==RefreshEvent || Test==OtherRefreshEvent)
  {
    LastPresent=0;
    AlreadyShown=0;
    ShowElements(Test==OtherRefreshEvent);
  }

  if (Test==StopEvent || Test==AbortEvent)
    return 0;

  return 1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Arrive()
//
// Arrives from the current element and calls the arrival function
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::Arrive(DialogElement &Present)
{
  if (LastPresent==&Present)
    return 1;

  LastPresent=&Present;
  Blaze.VisibleCursor();
  MouseShow();
  Blaze.GetXY(XSave,YSave);

  int Test=Present.Arrival();

  if (Test==RefreshEvent || Test==OtherRefreshEvent)
  {
    LastPresent=0;
    AlreadyShown=0;
    ShowElements(Test==OtherRefreshEvent);
  }

  if (Test==StopEvent || Test==AbortEvent)
    return 0;

  DialogElement *Save=DialogClass::Present;
  DialogClass::Present=&Present;

  Present.HighLight();
  ShowLocator();

  if (GroupLock!=Present.GroupCode)
    ShowHeading(0);

  ShowHeading(Present.GroupCode);
  GroupLock=Save->GroupCode;

  DialogClass::Present=Save;

  return 1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// NextElement()
//
// Jump to next element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::NextElement()
{
  DialogElement *Save=Present;
  int MustFind=0;

  if (Present->Available()!=CompleteEvent)
    MustFind=1;

  Present=Present->Next;

  for (int i=0;i<2;i++)
  {
    while (Present && Present!=Save)
    {
      if (Present->Available()==CompleteEvent)
      {
        if (!Depart(*Save))
          return 0;
        return 1;
      }

      Present=Present->Next;
    }

    if (!Save->Last)
    {
      Present=Save;
      return (MustFind)?0:1;
    }
    Present=First;
  }
  Present=Save;
  return (MustFind)?0:1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// PreviousElement()
//
// Jump to last element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::PreviousElement()
{
  DialogElement *Save=Present;
  int MustFind=0;

  if (Present->Available()!=CompleteEvent)
    MustFind=1;

  Present=Present->Last;

  for (int i=0;i<2;i++)
  {
    while (Present && Present!=Save)
    {
      if (Present->Available()==CompleteEvent)
      {
        if (!Depart(*Save))
          return 0;
        return 1;
      }

      Present=Present->Last;
    }
    if (!Save->Next)
    {
      Present=Save;
      return (MustFind)?0:1;
    }
    Present=Last;
  }
  Present=Save;
  return (MustFind)?0:1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// NextWithinGroup()
//
// Jump to next element within a group
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::NextWithinGroup()
{
  if (!Present->GroupCode)
    return 1;

  DialogElement *Save=Present;
  int MustFind=0;

  if (Present->Available()!=CompleteEvent)
    MustFind=1;

  Present=Present->Next;

  for (int i=0;i<2;i++)
  {
    while (Present && Present!=Save)
    {
      if (Present->Available()==CompleteEvent &&
        Present->GroupCode==Save->GroupCode)
      {
        if (!Depart(*Save))
          return 0;
        return 1;
      }

      Present=Present->Next;
    }
    if (!Save->Last)
    {
      Present=Save;
      return (MustFind)?0:1;
    }
    Present=First;
  }
  Present=Save;
  return (MustFind)?0:1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// PreviousWithinGroup()
//
// Jump to last element within a group
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::PreviousWithinGroup()
{
  if (!Present->GroupCode)
    return 1;

  DialogElement *Save=Present;
  int MustFind=0;

  if (Present->Available()!=CompleteEvent)
    MustFind=1;

  Present=Present->Last;

  for (int i=0;i<2;i++)
  {
    while (Present && Present!=Save)
    {
      if (Present->Available()==CompleteEvent &&
        Present->GroupCode==Save->GroupCode)
      {
        if (!Depart(*Save))
          return 0;
        return 1;
      }

      Present=Present->Last;
    }
    if (!Save->Next)
    {
      Present=Save;
      return (MustFind)?0:1;
    }
    Present=Last;
  }
  Present=Save;
  return (MustFind)?0:1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// NextGroup()
//
// Jump to next group or element, whichever is appropriate
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::NextGroup()
{
  if (!Present->GroupCode)
    return NextElement();

  DialogElement *Save=Present;
  int MustFind=0;

  if (Present->Available()!=CompleteEvent)
    MustFind=1;

  Present=Present->Next;

  for (int i=0;i<2;i++)
  {
    while (Present && Present!=Save)
    {
      if (Present->Available()==CompleteEvent &&
        (Present->GroupCode!=Save->GroupCode ||
         !Save->GroupCode))
      {
        if (!Depart(*Save))
          return 0;
        return 1;
      }

      Present=Present->Next;
    }
    if (!Save->Last)
    {
      Present=Save;
      return (MustFind)?0:1;
    }
    Present=First;
  }
  Present=Save;
  return (MustFind)?0:1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// PreviousGroup()
//
// Jump to last group or element, whichever is appropriate
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::PreviousGroup()
{
  if (!Present->GroupCode)
  {
    if (!(Present->Last && Present->Last->GroupCode) &&
        !(!Present->Last && Last->GroupCode))
      return PreviousElement();
  }

  DialogElement *Save=Present;
  int MustFind=0;

  if (Present->Available()!=CompleteEvent)
    MustFind=1;

  Present=Present->Last;

  for (int i=0;i<2;i++)
  {
    while (Present && Present!=Save)
    {
      if (Present->Available()==CompleteEvent &&
        (Present->GroupCode!=Save->GroupCode ||
         !Save->GroupCode))
      {
        if (Present->Last && Present->GroupCode)
        {
          int Group=Present->GroupCode;
          DialogElement *Saved=Present;
          DialogElement *Memory=0;

          Present=Present->Last;

          while (Present)
          {
            if (Present->Available()==CompleteEvent && Present->GroupCode==Group)
              Memory=Present;
            Present=Present->Last;
          }

          Present=(Memory)?Memory:Saved;
        }

        if (!Depart(*Save))
          return 0;
        return 1;
      }

      Present=Present->Last;
    }
    if (!Save->Next)
    {
      Present=Save;
      return (MustFind)?0:1;
    }
    Present=Last;
  }
  Present=Save;
  return (MustFind)?0:1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Valid()
//
// Checks validity of current element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DialogClass::Valid()
{
  return !(Present->Validation()==FailedEvent &&
    Present->Available()!=FailedEvent);
}

