//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
//

#include "fli.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>

int DialogClass::DialogTimer=16;

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DialogClass Constructors
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DialogClass::DialogClass(int Width,int Height,char *Title,int CloseIcon)
{
  CheckBigCursor=IsBigCursor;
  CheckVisible=Blaze.CheckVisible();

  Blaze.GetXY(PreXSave,PreYSave);

  TopTitle=Title;

  Grouped=0;
  HeadingStorage=0;
  HeadingCount=0;
  MultiTask=0;
  ActionTimer=0;
  BottomSave=0;
  LocatedFirst=0;
  LastPresent=0;
  XSave=0;
  YSave=0;
  UseAction=0;
  NoDefaults=0;
  GroupLock=0;

  AlreadyShown=0;

  First=0;
  Last=0;
  Current=0;

  Event::CloseIcon=CloseIcon;

  int Top=(Blaze.WhatHeight()-Height)/2;
  int Left=(Blaze.WhatWidth()-Width)/2;

  !Blaze;
  +Blaze;

  SpecifyWindow(Left,Top,Width,Height);
  Blaze.Window(Left,Top,Width,Height);

  ShowDialogBox();

  MouseHide();

  Blaze.EraseArea(1,1,Width-2,Height-2,Colors.DiaInterior);
  Blaze.Window(Left+1,Top+1,Width-2,Height-2);

  MouseShow();
}

DialogClass::DialogClass(int X,int Y,int Width,int Height,char *Title,int CloseIcon)
{
  CheckBigCursor=IsBigCursor;
  CheckVisible=Blaze.CheckVisible();

  Blaze.GetXY(PreXSave,PreYSave);

  TopTitle=Title;

  Grouped=0;
  HeadingStorage=0;
  HeadingCount=0;
  MultiTask=0;
  ActionTimer=0;
  BottomSave=0;
  LocatedFirst=0;
  LastPresent=0;
  XSave=0;
  YSave=0;
  UseAction=0;
  NoDefaults=0;

  AlreadyShown=0;

  Event::CloseIcon=CloseIcon;

  First=0;
  Last=0;
  Current=0;
  GroupLock=0;

  int Top=Y;
  int Left=X;

  if (X+Width>Blaze.WhatWidth())
    Left=Blaze.WhatWidth()-Width;
  if (Y+Height>Blaze.WhatHeight()-2)
    Top=Blaze.WhatHeight()-Height-1;

  !Blaze;
  +Blaze;

  SpecifyWindow(Left,Top,Width,Height);
  Blaze.Window(Left,Top,Width,Height);

  ShowDialogBox();

  MouseHide();

  Blaze.EraseArea(1,1,Width-2,Height-2,Colors.DiaInterior);
  Blaze.Window(Left+1,Top+1,Width-2,Height-2);

  MouseShow();
}

DialogClass::DialogClass()
{
  CheckBigCursor=IsBigCursor;
  CheckVisible=Blaze.CheckVisible();

  Blaze.GetXY(PreXSave,PreYSave);

  MouseHide();

  Grouped=0;
  HeadingStorage=0;
  HeadingCount=0;
  MultiTask=0;
  ActionTimer=0;
  BottomSave=0;
  LocatedFirst=0;
  LastPresent=0;
  XSave=0;
  YSave=0;
  UseAction=0;
  NoDefaults=0;
  CloseIcon=0;

  AlreadyShown=0;

  TopTitle=0;

  First=0;
  Last=0;
  Current=0;

  Width=Blaze.WhatWidth();
  Height=Blaze.WhatHeight();
  SpecifyWindow(0,0,Width,Height);
  Blaze.Window(0,0,Width,Height);

  MouseShow();

  !Blaze;
  +Blaze;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DialogClass Destructor
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DialogClass::~DialogClass()
{
  if (First)
  {
    Current=First;
    do
    {
      DialogElement *Save=Current;
      Current=Current->Next;
      delete Save;
    }
    while (Current);
  }

  if (HeadingStorage)
    free(HeadingStorage);

  if (BottomSave)
  {
    Blaze.PutArea(0,Blaze.WhatHeight()-1,BottomSave);
    delete BottomSave;
  }

  Blaze.GotoXY(PreXSave,PreYSave);
  Blaze.BigCursor(CheckBigCursor);
  if (CheckVisible)
    Blaze.VisibleCursor();
  else
    Blaze.InvisibleCursor();
}

