//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaVertRadioButton
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>
#include <alloc.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaVertRadio()
//
// Constructor for DiaVertRadio
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaVertRadio::DiaVertRadio(int _X,int _Y,int &_Item,int _ItemCount,char **_Items) :
  Item(_Item),
  Items(_Items),
  ItemCount(_ItemCount)
{
  X=_X;
  Y=_Y;

  IsQueued=0;

  int i, j=0, k;

  if (_ItemCount)
  {
    for (i=0;i<_ItemCount;i++)
      if ((k=strlen(_Items[i]))>j)
        j=k;
  }

  Width=j+6;
  Height=_ItemCount;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ~DiaVertRadio()
//
// Destructor for DiaVertRadio
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaVertRadio::~DiaVertRadio()
{
  if (IsQueued)
    free(Items);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// operator +
//
// Quick method to defining radio buttons
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaVertRadio::operator+ (char *Item)
{
  if (!IsQueued && Items)
    return;

  IsQueued++;
  Items=(char **)realloc(Items,sizeof(char *)*++ItemCount);
  Items[ItemCount-1]=Item;

  Height=ItemCount;
  Width=(strlen(Item)+6>Width)?(strlen(Item)+6):Width;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the radio buttons
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaVertRadio::Show()
{
  MouseHide();

  int Avail=(Available()==CompleteEvent);

  if (Item>=ItemCount)
    Item=ItemCount-1;

  if (Item<0)
    Item=0;

  for (int i=0;i<ItemCount;i++)
  {
    (*Blaze) (X,Y+i)
      << ((Avail)?Colors.RadioText:Colors.DiaDeadLocator)
      << " ("
      << ((Avail)?((i==Item)?Colors.RadioCheckMark:Colors.RadioText):Colors.DiaDeadLocator)
      << ((i==Item)?'\x7':' ')
      << ((Avail)?Colors.RadioText:Colors.DiaDeadLocator)
      << ") "
      << Items[i]
      << ' ';
    int Calc=5+strlen(Items[i]);
    Blaze->CharacterRepeater(X+Calc,Y+i,Width-Calc,
      (Avail)?Colors.RadioText:Colors.DiaDeadLocator,' ');
  }

  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// HighLight()
//
// Highlight the current radio button
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaVertRadio::HighLight()
{
  MouseHide();

  Blaze->LineAttribute(X,Y+Item,Width,Colors.RadioHiLite);
  Blaze->WindowGotoXY(X+2,Y+Item);

  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DiaVertRadio::EventHandler(int Event)
{
  if (Event==kbDown || Event==' ')
  {
    if (ItemCount>1)
    {
      Item=(Item==ItemCount-1)?0:(++Item);
      Show();
      HighLight();
    }
    return CompleteEvent;
  }

  if (Event==kbUp)
  {
    if (ItemCount>1)
    {
      Item=(!Item)?(ItemCount-1):(--Item);
      Show();
      HighLight();
    }
    return CompleteEvent;
  }

  if (Event==ValidatedMousedEvent && MouseEvent&MouseLeftButtonRelease)
  {
    MouseVertical-=Y;
    if (Item!=MouseVertical)
    {
      Item=MouseVertical;
      Show();
      HighLight();
    }
    return CompleteEvent;
  }

  return Event;
}
