//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaPushButton
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>
#include <dos.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaPushButton()
//
// Constructor for DiaPushButton
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaPushButton::DiaPushButton(int _X,int _Y,char *_Button,int _Action,
  int _Key,int _Active) :
  Button(_Button),
  Action(_Action)
{
  X=_X;
  Y=_Y;
  Width=strlen(_Button)+2-((strchr(_Button,'~'))?1:0);
  Height=1;
  Pushed=0;
  QuickKey=_Key;
  FusionHelp=_Action;
  Active=_Active;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the push button
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaPushButton::Show()
{
  MouseHide();

  int Avail=(Available()==CompleteEvent);

  (*Blaze) (X,Y)
    << ((Avail)?((!Active)?Colors.ButtonNormal:Colors.ButtonActive):
       Colors.DiaDeadLocator)
    << ' ';

  int Key;

  Key=Blaze->QuickDisplay(X+1,Y,
    (Avail)?((!Active)?Colors.ButtonBold:Colors.ButtonActive):
      Colors.DiaDeadLocator,
    (Avail)?((!Active)?Colors.ButtonNormal:Colors.ButtonActive):
      Colors.DiaDeadLocator,
    Button);

  if (!QuickKey)
    QuickKey=Key;

  (*Blaze)
    << ((Avail)?((!Active)?Colors.ButtonNormal:Colors.ButtonActive):
        Colors.DiaDeadLocator)
    << ' '
    << ((Avail)?Colors.DiaInterior:Colors.DiaDeadLocator)
    << '\xdc';

  Blaze->CharacterRepeater(X+1,Y+1,Width,
    (Avail)?Colors.DiaInterior:Colors.DiaDeadLocator,223);

  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// HighLight()
//
// Highlight the current push button
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaPushButton::HighLight()
{
  MouseHide();

  (*Blaze) (X,Y)
    << Colors.ButtonHiLite
    << ' ';

  Blaze->QuickDisplay(X+1,Y,Colors.ButtonHiLite,Colors.ButtonHiLite,Button);

  (*Blaze)
    << Colors.ButtonHiLite
    << ' '
    << Colors.DiaInterior
    << '\xdc';

  Blaze->CharacterRepeater(X+1,Y+1,Width,Colors.DiaInterior,223);
  Blaze->WindowGotoXY(X+1,Y);

  Pushed=0;

  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// PushIn()
//
// Push the button in
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaPushButton::PushIn()
{
  Pushed=1;

  MouseHide();

  Blaze->WindowGotoXY(X+2,Y);

  (*Blaze) (X,Y)
    << Colors.DiaInterior
    << ' '
    << Colors.ButtonHiLite
    << ' ';

  Blaze->QuickDisplay(X+2,Y,Colors.ButtonHiLite,Colors.ButtonHiLite,Button);

  (*Blaze)
    << Colors.ButtonHiLite
    << ' ';

  Blaze->CharacterRepeater(X+1,Y+1,Width,Colors.DiaInterior,' ');

  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DiaPushButton::EventHandler(int Event)
{
  if (Event==kbCr || Event==' ' || Event==QuickKey ||
    (Event>='a' && Event<='z' && (Event-32)==QuickKey) ||
    (Event==ValidatedMousedEvent && MouseEvent&MouseLeftButtonRelease))
  {
    PushIn();
    delay(50);
    HighLight();
    return Action;
  }

  if (Event==ValidatedMousedEvent && MouseEvent&MouseLeftButtonPress &&
    !Pushed)
    PushIn();
  else if (Pushed && Event!=ValidatedMousedEvent)
    HighLight();
  else if (!Pushed && Event==ValidatedMousedEvent && MouseButtons()&LeftButton)
    PushIn();

  return Event;
}
