//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaLong
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>
#include <stdlib.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaLong()
//
// Constructor
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaLong::DiaLong(int _X,int _Y,char *_Mask,long &_Value,int _NoEditErase) :
  Numerics(_NoEditErase), Value(_Value)
{
  X=_X;
  Y=_Y;
  Mask=_Mask;
  Width=strlen(Mask);
  Height=1;

  Numerics::Value=new char[30];
  ltoa(Value,Numerics::Value,10);

  AllowedAfterDecimal=0;

  if (strpbrk(Mask,"-+("))
    AllowedNegative++;

  CountPlaces(Mask,AllowedBeforeDecimal,AllowedAfterDecimal);
  TrimTrailingZeros();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaLong::Show()
{
  if (atol(Numerics::Value)!=Value)
    ltoa(Value,Numerics::Value,10);

  Numerics::Show();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DiaLong::EventHandler(int Event)
{
  int ReturnEvent=EventValidation(Event);

  if (ReturnEvent==CompleteEvent)
    Value=atol(Numerics::Value);

  HighLight();

  return ReturnEvent;
}
