//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaInt
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>
#include <stdlib.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaInt()
//
// Constructor
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaInt::DiaInt(int _X,int _Y,char *_Mask,int &_Value,int _NoEditErase) :
  Numerics(_NoEditErase), Value(_Value)
{
  X=_X;
  Y=_Y;
  Mask=_Mask;
  Width=strlen(Mask);
  Height=1;

  Numerics::Value=new char[20];
  itoa(Value,Numerics::Value,10);

  AllowedAfterDecimal=0;

  if (strpbrk(Mask,"-+("))
    AllowedNegative++;

  CountPlaces(Mask,AllowedBeforeDecimal,AllowedAfterDecimal);
  TrimTrailingZeros();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaInt::Show()
{
  if (atoi(Numerics::Value)!=Value)
    itoa(Value,Numerics::Value,10);

  Numerics::Show();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DiaInt::EventHandler(int Event)
{
  int ReturnEvent=EventValidation(Event);

  if (ReturnEvent==CompleteEvent)
    Value=atoi(Numerics::Value);

  HighLight();

  return ReturnEvent;
}
