//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaHorizRadioButton
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>
#include <alloc.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaHorizRadio()
//
// Constructor for DiaHorizRadio
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaHorizRadio::DiaHorizRadio(int _X,int _Y,int &_Item,int _ItemCount,char **_Items) :
  Item(_Item),
  Items(_Items),
  ItemCount(_ItemCount)
{
  X=_X;
  Y=_Y;

  IsQueued=0;

  int i, j=0;

  if (_ItemCount)
  {
    for (i=0;i<_ItemCount;i++)
      j+=(strlen(_Items[i])+5);

    j++;
  }

  Width=j;
  Height=1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ~DiaHorizRadio()
//
// Destructor for DiaHorizRadio
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaHorizRadio::~DiaHorizRadio()
{
  if (IsQueued)
    free(Items);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// operator +
//
// Quick method to defining radio buttons
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaHorizRadio::operator+ (char *Item)
{
  if (!IsQueued && Items)
    return;

  if (!IsQueued)
    Width=1;

  IsQueued++;
  Items=(char **)realloc(Items,sizeof(char *)*++ItemCount);
  Items[ItemCount-1]=Item;

  Height=1;
  Width+=(strlen(Item)+5);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the radio buttons
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaHorizRadio::Show()
{
  MouseHide();

  int Avail=(Available()==CompleteEvent);

  (*Blaze) (X,Y) << ((Avail)?Colors.RadioText:Colors.DiaDeadLocator) << ' ';

  if (Item>=ItemCount)
    Item=ItemCount-1;

  if (Item<0)
    Item=0;

  for (int i=0;i<ItemCount;i++)
  {
    (*Blaze)
      << ((Avail)?Colors.RadioText:Colors.DiaDeadLocator)
      << '('
      << ((Avail)?((i==Item)?Colors.RadioCheckMark:Colors.RadioText):Colors.DiaDeadLocator)
      << ((i==Item)?'\x7':' ')
      << ((Avail)?Colors.RadioText:Colors.DiaDeadLocator)
      << ") "
      << Items[i]
      << ' ';
  }

  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// HighLight()
//
// Highlight the current radio button
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaHorizRadio::HighLight()
{
  MouseHide();

  for (int i=0,j=0;i<Item;i++)
    j+=(strlen(Items[i])+5);

  Blaze->LineAttribute(X+j,Y,strlen(Items[Item])+6,
    Colors.RadioHiLite);
  Blaze->WindowGotoXY(X+j+2,Y);

  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DiaHorizRadio::EventHandler(int Event)
{
  if (Event==kbRight || Event==' ')
  {
    if (ItemCount>1)
    {
      Item=(Item==ItemCount-1)?0:(++Item);
      Show();
      HighLight();
    }
    return CompleteEvent;
  }

  if (Event==kbLeft)
  {
    if (ItemCount>1)
    {
      Item=(!Item)?(ItemCount-1):(--Item);
      Show();
      HighLight();
    }
    return CompleteEvent;
  }

  if (Event==ValidatedMousedEvent && MouseEvent&MouseLeftButtonRelease)
  {
    MouseHorizontal-=X;

    int Position=0;
    int Current=0;

    do
      Position+=(5+strlen(Items[Current++]));
    while (MouseHorizontal>Position);

    Current--;
    Item=Current;
    Show();
    HighLight();
    return CompleteEvent;
  }

  return Event;
}
