//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaFloat
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaFloat()
//
// Constructor
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaFloat::DiaFloat(int _X,int _Y,char *_Mask,float &_Value,int _NoEditErase) :
  Numerics(_NoEditErase), Value(_Value)
{
  X=_X;
  Y=_Y;
  Mask=_Mask;
  Width=strlen(Mask);
  Height=1;

  AllowedAfterDecimal=0;

  if (strpbrk(Mask,"-+("))
    AllowedNegative++;

  CountPlaces(Mask,AllowedBeforeDecimal,AllowedAfterDecimal);

  Numerics::Value=new char[40];
  sprintf(Numerics::Value,"%-*.*f",AllowedBeforeDecimal,AllowedAfterDecimal,Value);
  TrimTrailingZeros();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaFloat::Show()
{
  if (atof(Numerics::Value)!=Value)
  {
    sprintf(Numerics::Value,"%-*.*f",AllowedBeforeDecimal,AllowedAfterDecimal,Value);
    TrimTrailingZeros();
  }

  Numerics::Show();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DiaFloat::EventHandler(int Event)
{
  int ReturnEvent=EventValidation(Event);

  if (ReturnEvent==CompleteEvent)
    Value=atof(Numerics::Value);

  HighLight();

  return ReturnEvent;
}
