//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaCombo
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>
#include <ctype.h>
#include <string.h>
#include <dos.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaCombo()
//
// Constructor
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaCombo::DiaCombo(int _X,int _Y,int &NumberOfComboItems,char *_Mask,
  char *_Value,int _VisualWidth,char MaskCharacter,int MaskWidth,
  int _NoEditErase) :
  DiaChar(_X,_Y,_Mask,_Value,_VisualWidth,MaskCharacter,MaskWidth,_NoEditErase),
  ItemCount(NumberOfComboItems)
{
  DialogElement::Width++;
  Item=0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the character/combo element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaCombo::Show()
{
  DiaChar::Show();
  (*Blaze) (X+DialogElement::Width-1,Y) <<
    ((Available()==CompleteEvent)?Colors.DiaQuickKey:Colors.DiaDeadLocator) << '\x1f';
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// HighLight()
//
// Highlight the combo/character element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaCombo::HighLight()
{
  DiaChar::HighLight();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

// These classes are for the combo box drop down (it is a pick list)

class ComboPicker : public DiaPickGeneric
{
public:

  DiaCombo *Combo;

  ComboPicker(int Width,int Height,int &Item,int &NumberOfItems,
    DiaCombo *ComboLocation) :
    DiaPickGeneric(0,0,Width,Height,Item,NumberOfItems),
    Combo(ComboLocation) { }

  char *GetItem(int);
};

char *ComboPicker::GetItem(int Item)
{
  return Combo->GetItem(Item);
}

class ComboHandler : public DialogClass
{
public:

  ComboHandler(int X,int Y,int Width,int Height) :
    DialogClass(X,Y,Width,Height,"",0) { }

  int EventHandler(int);

};

int ComboHandler::EventHandler(int Event)
{
  if (Event==kbEsc ||
      Event==kbCr ||
      Event==OutsideEvent)
    return StopEvent;
  return CompleteEvent;
}

// Here is the event handler for the DiaCombo element

int DiaCombo::EventHandler(int Event)
{
  if (Event==kbDown)
  {
    Item=(Item==ItemCount-1)?0:(++Item);
    strcpy(Value,GetItem(Item));
    CurrentLocation=0;
    AtLeft=0;
    HighLight();
    return CompleteEvent;
  }
  else if (Event==kbUp)
  {
    Item=(!Item)?(ItemCount-1):(--Item);
    strcpy(Value,GetItem(Item));
    CurrentLocation=0;
    AtLeft=0;
    HighLight();
    return CompleteEvent;
  }
  else if ((Event==ValidatedMousedEvent && MouseEvent==MouseLeftButtonRelease &&
    MouseHorizontal==X+DialogElement::Width-1 && MouseVertical==Y) || Event==' ')
  {
    int X, Y, Width, Height;
    int WinX=0, WinY=0, WinWidth=0, WinHeight=0;

    Blaze->WindowInformation(WinX,WinY,WinWidth,WinHeight);

    Width=DialogElement::Width+4;
    Height=7;

    X=WinX+DialogElement::X;
    Y=WinY+DialogElement::Y+1;

    if (X+Width>Blaze->WhatWidth())
      X=Blaze->WhatWidth()-Width-1;

    if (Y+Height>Blaze->WhatHeight()-1)
      Y=Blaze->WhatHeight()-Height-1;

    ComboHandler &Dialog = *new ComboHandler(X,Y,Width+2,Height);

    Dialog.Element(new ComboPicker(Width-3,Height-2,Item,ItemCount,this));
    Dialog.Help("Select an item from the list box");

    int WhatLeft=Dialog.UseDialog();
    delete &Dialog;

    if (WhatLeft==kbCr || MouseEvent&MouseDoubleClick)
    {
      strcpy(Value,GetItem(Item));
      CurrentLocation=0;
      AtLeft=0;
      HighLight();
    }

    return CompleteEvent;
  }

  return DiaChar::EventHandler(Event);
}
