//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaCheckBox
//

#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaCheckBox()
//
// Constructor for DiaCheckBox
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaCheckBox::DiaCheckBox(int _X,int _Y,int &_Checked,char *_CheckText,int Quick) :
  Checked(_Checked),
  CheckText(_CheckText)
{
  X=_X;
  Y=_Y;
  QuickKey=Quick;
  Width=strlen(_CheckText)+6-((strchr(_CheckText,'~'))?1:0);
  Height=1;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the check box
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaCheckBox::Show()
{
  MouseHide();

  int Avail=(Available()==CompleteEvent);

  (*Blaze) (X,Y)
    << ((Avail)?Colors.CheckText:Colors.DiaDeadLocator)
    << " ["
    << ((Avail)?Colors.CheckMark:Colors.DiaDeadLocator)
    << ((Checked)?'X':' ')
    << ((Avail)?Colors.CheckText:Colors.DiaDeadLocator)
    << "] ";

  Blaze->QuickDisplay(X+5,Y,
    (Avail)?Colors.CheckQuickKey:Colors.DiaDeadLocator,
    (Avail)?Colors.CheckText:Colors.DiaDeadLocator,CheckText);

  (*Blaze) << ' ';

  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// HighLight()
//
// Highlight the check box
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaCheckBox::HighLight()
{
  MouseHide();

  (*Blaze) (X,Y)
    << Colors.CheckHiLite
    << " ["
    << ((Checked)?'X':' ')
    << "] ";

  Blaze->QuickDisplay(X+5,Y,Colors.CheckHiLite,Colors.CheckHiLite,CheckText);

  (*Blaze) << ' ';

  Blaze->WindowGotoXY(X+2,Y);
  MouseShow();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DiaCheckBox::EventHandler(int Event)
{
  if (Event==' ' ||
    (Event==ValidatedMousedEvent && MouseEvent&MouseLeftButtonRelease) ||
    Event==QuickKey)
  {
    Checked=(Checked)?0:1;
    HighLight();
    return CompleteEvent;
  }

  return Event;
}
