//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// DialogClass
// DiaBcd
//

#include <bcd.h>
#include "fli.h"
#include "elements.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <string.h>
#include <stdlib.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DiaBcd()
//
// Constructor
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DiaBcd::DiaBcd(int _X,int _Y,char *_Mask,bcd &_Value,int _NoEditErase) :
  Numerics(_NoEditErase), Value(_Value)
{
  X=_X;
  Y=_Y;
  Mask=_Mask;
  Width=strlen(Mask);
  Height=1;

  AllowedAfterDecimal=0;

  if (strpbrk(Mask,"-+("))
    AllowedNegative++;

  CountPlaces(Mask,AllowedBeforeDecimal,AllowedAfterDecimal);

  Numerics::Value=new char[30];

  double ConvertedBcd=real(_Value);
  gcvt(ConvertedBcd,AllowedBeforeDecimal+AllowedAfterDecimal,Numerics::Value);
  TrimTrailingZeros();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Show()
//
// Show the element
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void DiaBcd::Show()
{
  double CovertedValue=atof(Numerics::Value);
  bcd CheckValue=bcd(CovertedValue);

  if (Value!=CheckValue)
  {
    double ConvertedBcd=real(Value);
    gcvt(ConvertedBcd,AllowedBeforeDecimal+AllowedAfterDecimal,Numerics::Value);
    TrimTrailingZeros();
  }

  Numerics::Show();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EventHandler()
//
// Handles the events
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int DiaBcd::EventHandler(int Event)
{
  int ReturnEvent=EventValidation(Event);

  if (ReturnEvent==CompleteEvent)
  {
    double CovertedValue=atof(Numerics::Value);
    Value=bcd(CovertedValue);
  }

  HighLight();

  return ReturnEvent;
}
