//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// UserBoxDefine()
//
// Define a custom user box
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::UserBoxDefine(int TopLeft, int TopCenter, int TopRight,
  int CenterLeft, int CenterFill, int CenterRight, int BottomLeft,
  int BottomCenter, int BottomRight)
{
  BlazeClass::TopLeft=TopLeft;
  BlazeClass::TopCenter=TopCenter;
  BlazeClass::TopRight=TopRight;
  BlazeClass::CenterLeft=CenterLeft;
  BlazeClass::CenterFill=CenterFill;
  BlazeClass::CenterRight=CenterRight;
  BlazeClass::BottomLeft=BottomLeft;
  BlazeClass::BottomCenter=BottomCenter;
  BlazeClass::BottomRight=BottomRight;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// UserBoxDefineQuick()
//
// Define a quick custom user box
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::UserBoxDefineQuick(int Style)
{
  if (Style<1 || Style>9)
    return;

  Style--;

  static char *Styles[] = { "Ŀ ",
                            "ͻ ͼ",
                            "ķ Ľ",
                            "͸ ",
                            "ķ ͼ",
                            "͸ ;",
                            " ",
                            "Ŀ ;",
                            "ͻ Ľ" };

  BlazeClass::TopLeft=*(Styles[Style]+0);
  BlazeClass::TopCenter=*(Styles[Style]+1);
  BlazeClass::TopRight=*(Styles[Style]+2);
  BlazeClass::CenterLeft=*(Styles[Style]+3);
  BlazeClass::CenterFill=*(Styles[Style]+4);
  BlazeClass::CenterRight=*(Styles[Style]+5);
  BlazeClass::BottomLeft=*(Styles[Style]+6);
  BlazeClass::BottomCenter=*(Styles[Style]+7);
  BlazeClass::BottomRight=*(Styles[Style]+8);
}

