//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <dos.h>

#define I asm

extern int SingleCharacter;

#if defined(__LARGE__) || defined(__HUGE__) || defined(__COMPACT__)
#define ISFAR
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// << operator
//
// Output text
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& BlazeClass::operator<< (char *String)
{
  if (!String)
    return *this;

  int WinHigh =     BlazeClass::WinHigh;
  int WinWide =     BlazeClass::WinWide;
  int WinX =        BlazeClass::WinX;
  int WinY =        BlazeClass::WinY;
  int ScreenWidth = BlazeClass::QuickWidth;
  int Clip =        BlazeClass::Clip;
  int X =           BlazeClass::X;
  int Y =           BlazeClass::Y;
  int Scrolling =   BlazeClass::Scrolling;
  int Color =       BlazeClass::Color;
  int SinChar =     SingleCharacter;

  if (Center || FlushRight)
  {
    #ifndef ISFAR
      I mov ax,ds
      I mov es,ax
      I mov di,String
      I xor ax,ax
    #else
      I les di,String
      I xor ax,ax
      I cmp ax,(word ptr (String) [2])
      I jne Start
      I cmp ax,di
      I je Out
    #endif

    Start:

    I cld
    I mov cx, -1
    I repne scasb
    I xchg ax,cx
    I not ax
    I dec ax
    I mov di,ax

    if (Center)
    {
      if (_DI>WinWide)
        _DX=0;
      else
        _DX=(WinWide-_DI)>>1;
      X=_DX;
      Center=0;
      goto Begin;
    }
    else
    {
      if (_DI>WinWide)
        _DX=0;
      else
        _DX=WinWide-_DI;
      X=_DX;
      FlushRight=0;
      goto Begin;
    }

    Out:

    return *this;
  }

Begin:

  #ifdef ISFAR
    I push ds
    I lds si,String
  #else
    I mov si,String
  #endif

  void far *OUTPUT=BlazeClass::OUTPUT;

ComputeVideoCoordinates:

  I les di,OUTPUT

  _DI += ((WinY+Y)*ScreenWidth)+((WinX+X)*2);

  I mov ah,byte ptr Color
  I cld

StringLoop:

  I lodsb
  I or al,al
  I jne TestLineFeed

  #ifdef ISFAR
    I pop ds
  #endif

  BlazeClass::Y=Y;
  BlazeClass::X=X;

  return *this;

TestLineFeed:

  if (!SinChar)
  {

      I cmp al,10
      I jne TestCarraigeReturn
      I jmp LineFeed

    TestCarraigeReturn:

      I cmp al,13
      I jne DisplayCharacter

      X=0;

      I jmp ComputeVideoCoordinates

  }

DisplayCharacter:

  if (!Clip)
  {
    I stosw

    X++;

    I mov dx,word ptr WinWide
    I cmp word ptr X,dx
    I jl StringLoop

    goto Assess;
  }
  else
  {
    I mov dx,word ptr WinWide
    I cmp word ptr X,dx
    I jl Next
    I jmp VirReality

Next:

    I mov dx,word ptr WinHigh
    I cmp word ptr Y,dx
    I jl Output

VirReality:

    // Virtual reality

    I inc di
    I inc di

    X++;

    goto StringLoop;

    // Visual reality

Output:

    I stosw

    X++;

    goto StringLoop;
  }

Assess:

  X=0;

LineFeed:

  if (!Clip)
  {
    I mov cx,WinHigh
    I dec cx
    I cmp cx,Y
    I je BumpUpLines
  }

  Y++;

  I jmp ComputeVideoCoordinates

BumpUpLines:

  if (Scrolling)
    goto ScrollWindow;

  X=0;

  I jmp ComputeVideoCoordinates

ScrollWindow:

  _DI = FP_OFF(OUTPUT);

  if (WinX || WinY)
    _DI += ((WinY*ScreenWidth)+(WinX*2));

  I push si
  I mov si,di
  I mov cx,WinWide
  I mov dx,WinHigh
  I dec dx
  I mov bx,cx
  I mov ax,es
  I push ds
  I mov ds,ax
  I mov si,di
  I add si,ScreenWidth
  I cld

looped:

  I push di
  I push si

  I mov cx,bx
  I rep movsw

  I pop si
  I pop di
  I add si,ScreenWidth
  I add di,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped

  I pop ds
  I pop si

  _DI = FP_OFF(OUTPUT);

  if (!WinX && !WinY)
    _DI += ((WinHigh-1)*ScreenWidth);
  else
    _DI += (((WinY+WinHigh-1)*ScreenWidth)+(WinX*2));

  I mov cx,WinWide

  I mov al,32
  I mov ah,byte ptr Color
  I rep stosw

  X=0;
  I jmp ComputeVideoCoordinates

  return *this;
}

