//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

#if defined(__LARGE__) || defined(__HUGE__) || defined(__COMPACT__)
#define ISFAR
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ScrollUp()
//
// Scrolls a region upward
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::ScrollUp(int X,int Y,int Width,int Height)
{
  if (Width<2 || Height<2)
    return;

  int ScreenWidth = BlazeClass::QuickWidth;
  int Locator = (Y*ScreenWidth)+(X*2);

  void far *OUTPUT=BlazeClass::OUTPUT;
  I les di,OUTPUT

  _DI += Locator;

  I mov bx,[Width]
  I mov dx,[Height]
  I dec dx

  I mov ax,es
  I push ds
  I mov ds,ax
  I mov si,di
  I add si,ScreenWidth
  I cld

looped:

  I push di
  I push si
  I mov cx,bx
  I rep movsw
  I pop si
  I pop di
  I add si,ScreenWidth
  I add di,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped

  I pop ds
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ScrollDown()
//
// Scrolls a region downward
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::ScrollDown(int X,int Y,int Width,int Height)
{
  if (Width<2 || Height<2)
    return;

  int ScreenWidth = BlazeClass::QuickWidth;
  int Locator = ((Y+Height-1)*ScreenWidth)+(X*2);

  void far *OUTPUT=BlazeClass::OUTPUT;
  I les di,OUTPUT

  _DI += Locator;

  I mov bx,[Width]
  I mov dx,[Height]
  I dec dx

  I push ds
  I mov ax,es
  I mov ds,ax
  I mov si,di
  I sub si,ScreenWidth
  I cld

looped:

  I push di
  I push si
  I mov cx,bx
  I rep movsw
  I pop si
  I pop di
  I sub si,ScreenWidth
  I sub di,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped

  I pop ds
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ScrollLeft()
//
// Scrolls a region leftward
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::ScrollLeft(int X,int Y,int Width,int Height)
{
  if (Width<2 || Height<2)
    return;

  I push ds

  int ScreenWidth = BlazeClass::QuickWidth;
  int Locator = (Y*ScreenWidth)+(X*2);

  void far *OUTPUT=BlazeClass::OUTPUT;
  I lds si,OUTPUT
  I les di,OUTPUT

  _CX = Locator;
  _DI += _CX;
  _SI += (_CX+2);

  I push di

  I mov bx,[Width]
  I dec bx
  I mov dx,[Height]

  I cld

looped:

  I push di
  I push si
  I mov cx,bx
  I rep movsw
  I pop si
  I pop di
  I add si,ScreenWidth
  I add di,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped

  I pop di
  I pop ds
 
  I dec word ptr Width
  I add di,Width
  I add di,Width

  ScreenWidth-=2;

  I cld
  I mov al,32

  #ifdef ISFAR
    I push es
  #endif

  _AH=Color;

  #ifdef ISFAR
    I pop es
  #endif

  I mov cx,Height

again:

  I stosw
  I add di,ScreenWidth
  I loop again
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ScrollRight()
//
// Scrolls a region rightward
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::ScrollRight(int X,int Y,int Width,int Height)
{
  if (Width<2 || Height<2)
    return;

  I push ds

  int ScreenWidth = BlazeClass::QuickWidth;
  int Locator = (Y*ScreenWidth)+((X+Width-1)*2);

  void far *OUTPUT=BlazeClass::OUTPUT;
  I lds si,OUTPUT
  I les di,OUTPUT

  _CX = Locator;
  _DI += _CX;
  _SI += (_CX-2);

  I push di

  I mov bx,[Width]
  I dec bx
  I mov dx,[Height]

  I std

looped:

  I push di
  I push si
  I mov cx,bx
  I rep movsw
  I pop si
  I pop di
  I add si,ScreenWidth
  I add di,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped

  I pop di
  I pop ds
 
  I dec word ptr Width
  I sub di,Width
  I sub di,Width

  ScreenWidth-=2;

  I cld
  I mov al,32

  #ifdef ISFAR
    I push es
  #endif

  _AH=Color;

  #ifdef ISFAR
    I pop es
  #endif

  I mov cx,Height

again:

  I stosw
  I add di,ScreenWidth
  I loop again
}

