//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// PutArea()
//
// Puts a saved area on the display
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::PutArea(int X,int Y,void far *S)
{
  int ScreenWidth = BlazeClass::QuickWidth;

  void far *OUTPUT=BlazeClass::OUTPUT;
  I les di,OUTPUT

  _DI += ((Y*ScreenWidth)+(X*2));

  I push ds

  I lds si,S

  I mov bx,word ptr ds:[si]
  I mov dx,word ptr ds:[si+2]

  I add si,4

  I cld

looped:

  I push di
  I mov cx,bx

  I rep movsw

  I pop di
  I add di,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped

  I pop ds
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// GetArea()
//
// Gets an area from the display
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::GetArea(int X,int Y,int Width,int Height,void far *S)
{
  if (Width<1 || Height<1)
    return;

  int ScreenWidth = BlazeClass::QuickWidth;

  void far *OUTPUT=BlazeClass::OUTPUT;

  I mov bx,[Width]
  I mov dx,[Height]

  I push ds

  I push dx
  I push bx

  I les di,S

  I lds si,OUTPUT

  _SI += ((Y*ScreenWidth)+(X*2));

  I pop bx
  I pop dx

  I mov word ptr es:[di],bx
  I mov word ptr es:[di+2],dx

  I add di,4

  I cld

looped:

  I push si
  I mov cx,bx

  I rep movsw

  I pop si
  I add si,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped

  I pop ds
}

