//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ToggleIntense()
//
// Turns off the blinking bit and permits intense background colors or
// vice-versa
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int BlazeClass::ToggleIntense()
{
  if (!Intense)
  {
    I mov ax,1a00h    // EGA/VGA
    I int 10h
    int l = _AL;
    int t = _BL;
    if (l==0x1a && t>=4)
    {
      I mov ah,10h
      I mov al,3
      I mov bl,0
      I int 10h
      Intense++;
    }
  }
  else
  {
    I mov ax,1a00h    // EGA/VGA
    I int 10h
    int l = _AL;
    int t = _BL;
    if (l==0x1a && t>=4)
    {
      I mov ah,10h
      I mov al,3
      I mov bl,1
      I int 10h
      Intense=0;
    }
  }
  return Intense;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ChangePalette()
//
// Changes the color palette on a EGA or VGA
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int BlazeClass::ChangePalette(int PaletteRegister,int Color)
{
  I mov ax,1a00h      // EGA/VGA
  I int 10h
  int l = _AL;
  int t = _BL;
  if (l==0x1a && t>=4)
  {
    I mov ah,10h
    I mov al,0
    I mov bh,byte ptr Color
    I mov bl,byte ptr PaletteRegister
    I int 10h
    return 1;
  }
  return 0;
}

