//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#include "fli.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

extern int HelpSystemAvailable;
extern int DisabledHelp;

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// HelpLine()
//
// Displays help on the bottom of the screen
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::HelpLine(int FusionHelp,char *HelpText)
{
  BlazeClass Blaze;

  Blaze.EraseArea(0,Blaze.WhatHeight()-1,Blaze.WhatWidth(),1,
    Colors.PromptLineNormal);

  !Blaze;
  +Blaze;

  if (!DisabledHelp)
  {
    Blaze (9,Blaze.WhatHeight()-1)
      << Colors.PromptLineNormal
      << '\xb3';

    if (FusionHelp && HelpSystemAvailable)
    {
      Blaze (1,Blaze.WhatHeight()-1)
        << Colors.PromptLineBold
        << "F1"
        << MoveRight
        << Colors.PromptLineNormal
        << "Help";
    }
  }

  if (HelpText)
  {
    Blaze ((DisabledHelp)?1:11,Blaze.WhatHeight()-1)
      << Colors.PromptLineNormal
      << HelpText;
  }
}
