//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// GotoXY()
//
// Moves the hardware cursor to a new position on the screen
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::GotoXY(int X,int Y)
{
  I mov dx,X
  I mov ax,Y
  I mov dh,al
  I xor bh,bh
  I mov ah,2
  I int 10h
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// WindowGotoXY()
//
// Moves the hardware cursor to a new position within the window
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::WindowGotoXY(int X,int Y)
{
  int _X=WinX+X;
  int _Y=WinY+Y;

  if (_X>=WinX+WinWide)
    _X=(WinX+WinWide)-1;

  if (_Y>=WinY+WinHigh)
    _Y=(WinY+WinHigh)-1;

  I mov dx,_X
  I mov ax,_Y
  I mov dh,al
  I xor bh,bh
  I mov ah,2
  I int 10h
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// () operator
//
// Moves the Output or Blaze cursor to a new position
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& BlazeClass::operator() (int X,int Y)
{
  if (X<0 || Y<0)
    return *this;

  BlazeClass::X=X;
  BlazeClass::Y=Y;

  return *this;
}
