//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Centered()
//
// Manipulator to force centered Blaze text
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& Centered(BlazeClass& BC)
{
  if (!BC.FlushRight)
    BC.Center=1;
  return BC;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Flushed()
//
// Manipulator to force text that is flushed right
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& Flushed(BlazeClass& BC)
{
  if (!BC.Center)
    BC.FlushRight=1;
  return BC;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MoveLeft()
//
// Manipulator to move the Blaze output location one position left
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& MoveLeft(BlazeClass& BC)
{
  if (BC.X)
    BC.X--;
  return BC;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MoveRight()
//
// Manipulator to move the Blaze output location one position right
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& MoveRight(BlazeClass& BC)
{
  if (BC.X!=BC.WinWide-1)
    BC.X++;
  return BC;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MoveUp()
//
// Manipulator to move the Blaze output location one position up
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& MoveUp(BlazeClass& BC)
{
  if (BC.Y)
    BC.Y--;
  return BC;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MoveDown()
//
// Manipulator to move the Blaze output location one position down
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& MoveDown(BlazeClass& BC)
{
  if (BC.Y!=BC.WinHigh-1)
    BC.Y++;
  return BC;
}

