//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#ifndef MK_FP
#define MK_FP(seg,ofs)  ((void _seg *)(seg) + (void near *)(ofs))
#endif

#define I asm

extern void CompleteMouseReset(); // To reset mouse after video switch

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// [] operator
//
// Change the current text mode to another one or an extended one
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

BlazeClass& BlazeClass::operator[] (int ExtendedVideoMode)
{
  if (!ExtendedVideoMode)
    goto GetInformation;
  else if (ExtendedVideoMode==500) // 80x25
  {
    I int 11h
    if ((_AX&48)==48)
    {
      I mov ax,7
      I int 10h
    }
    else
    {
      I mov ax,3
      I int 10h
    }
    goto GetInformation;
  }
  else if (ExtendedVideoMode==600) // 80x43 80x50
  {
    char l, t, k;

    I int 11h
    if ((_AX&48)==48)
    {
      I mov ax,7
      I int 10h
    }
    else
    {
      I mov ax,3
      I int 10h
    }

    I mov ah,0fh
    I int 10h
    I mov ax,1a00h
    I int 10h
    I mov l,al;
    I mov t,bl;

    if (l==0x1a)
    {
      switch (t)
      {
        case 4:
        case 5:
          I mov word ptr k,43;
          break;
        case 7:
        case 8:
        case 11:
        case 12:
          I mov word ptr k,50;
          break;
        default:
          I mov word ptr k,25;
          break;
      }
    }
    else
    {
      I mov ah,12h
      I mov bl,10h
      I int 10h

      if (_BL==0x10)
        I mov word ptr k,25
      else
        I mov word ptr k,43
    }

    if (k>25)
    {
      I mov ax,1112h
      I xor bl,bl
      I int 10h
      I mov ax,1103h
      I xor bl,bl
      I int 10h
    }

    goto GetInformation;
  }

  I int 11h
  if ((_AX&48)==48)
  {
    I mov ax,7
    I int 10h
  }
  else
  {
    I mov ax,3
    I int 10h
  }

  I mov ax,ExtendedVideoMode
  I int 10h

GetInformation:

  ScreenHeight=(*(char far *)MK_FP(0x40,0x84))+1;
  ScreenHeight=(ScreenHeight==1)?25:ScreenHeight;

  _AH=0x0f;
  I int 10h
  ScreenWidth=_AH;

  QuickWidth=ScreenWidth*2;

  WinWide=ScreenWidth;
  WinHigh=ScreenHeight;
  WinX=0;
  WinY=0;
  X=0;
  Y=0;

  if (MouseAvailable)
    CompleteMouseReset();

  return *this;
}

