//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <dos.h>

#define I asm

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// InvisibleCursor()
//
// Hides the hardware cursor
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::InvisibleCursor()
{
  I mov ah,3
  I xor bh,bh
  I int 10h
  I mov ah,1
  I or ch,00100000b
  I int 10h
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// VisibleCursor()
//
// Un-Hides the hardware cursor
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::VisibleCursor()
{
  I mov ah,3
  I xor bh,bh
  I int 10h
  I mov ah,1
  I and ch,11011111b
  I int 10h
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// BigCursor
//
// Makes cursor bigger or smaller
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int IsBigCursor=0;

void BlazeClass::BigCursor(int Size)
{
  IsBigCursor=Size;
  if (Size)
  {
    if (VIDEO==(char far *)0xb8000000L)
    {
      if (WhatHeight()>=43)
        _CL=8;
      else
        _CL=7;
    }
    else
      _CL=12;
    _CH=0;
  }
  else
  {
    if (VIDEO==(char far *)0xb8000000L)
      _CH=6, _CL=7;
    else
      _CH=11, _CL=12;
  }
  _AH=1;
  __int__(0x10);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CheckVisible
//
// Returns a 1 if visible or 0 if not visible
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int BlazeClass::CheckVisible()
{
  I mov ah,3
  I xor bh,bh
  I int 10h

  return (_CH&0x20)?0:1;
}

