//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ChangeForeground()
//
// Changes the foreground (color) of a region of the screen
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::ChangeForeground(int X,int Y,int Width,int Height,int Color)
{
  if (!Width || !Height || X>=WinWide || Y>=WinHigh)
    return;

  int ScreenWidth = BlazeClass::QuickWidth;
  int Locator = ((WinY+Y)*ScreenWidth)+((WinX+X)*2);

  if (X+Width>=WinWide)
    Width=WinWide-X;

  if (Y+Height>=WinHigh)
    Height=WinHigh-Y;

  void far *OUTPUT=BlazeClass::OUTPUT;
  I les di,OUTPUT
  I add di,Locator

  I mov bx,[Width]
  I mov dx,[Height]

  I mov ah,byte ptr Color
  I and ah,00000111b

  I cld

looped:

  I push di
  I mov cx,bx

looper:

  I inc di
  I mov al,byte ptr es:[di]
  I and al,11111000b
  I or al,ah
  I stosb
  I loop looper
  I pop di
  I add di,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ChangeBackground()
//
// Changes the background (color) of a region of the screen
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::ChangeBackground(int X,int Y,int Width,int Height,int Color)
{
  if (!Width || !Height || X>=WinWide || Y>=WinHigh)
    return;

  int ScreenWidth = BlazeClass::QuickWidth;
  int Locator = ((WinY+Y)*ScreenWidth)+((WinX+X)*2);

  if (X+Width>=WinWide)
    Width=WinWide-X;

  if (Y+Height>=WinHigh)
    Height=WinHigh-Y;

  void far *OUTPUT=BlazeClass::OUTPUT;
  I les di,OUTPUT
  I add di,Locator

  I mov bx,[Width]
  I mov dx,[Height]

  I mov ah,byte ptr Color
  I and ah,01110000b

  I cld

looped:

  I push di
  I mov cx,bx

looper:

  I inc di
  I mov al,byte ptr es:[di]
  I and al,10001111b
  I or al,ah
  I stosb
  I loop looper
  I pop di
  I add di,ScreenWidth
  I dec dx
  I or dx,dx
  I jne looped
}
