//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// BoxFilled()
//
// Draws and fills a box on the screen
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::BoxFilled(int X,int Y,int Width,int Height,int Color)
{
  if (Width<2 || Height<2 || X>=WinWide || Y>=WinHigh)
    return;

  char TopLeft = BlazeClass::TopLeft;
  char TopCenter = BlazeClass::TopCenter;
  char TopRight = BlazeClass::TopRight;
  char CenterLeft = BlazeClass::CenterLeft;
  char CenterFill = BlazeClass::CenterFill;
  char CenterRight = BlazeClass::CenterRight;
  char BottomLeft = BlazeClass::BottomLeft;
  char BottomCenter = BlazeClass::BottomCenter;
  char BottomRight = BlazeClass::BottomRight;

  int ScreenWidth = BlazeClass::QuickWidth;
  int WinWide = BlazeClass::WinWide;
  int WinHigh = BlazeClass::WinHigh;

  if (Width>2 && Height>2 && X+1<WinWide && Y+1<WinHigh)
  {

    X++;
    Y++;

    int SaveWide=Width;
    int SaveHeight=Height;

    Width-=2;
    Height-=2;

    int Locator = ((WinY+Y)*ScreenWidth)+((WinX+X)*2);

    if (X+Width>=WinWide)
      Width=WinWide-X;

    if (Y+Height>=WinHigh)
      Height=WinHigh-Y;

    void far *OUTPUT=BlazeClass::OUTPUT;
    I les di,OUTPUT
    I add di,Locator

    I mov bx,[Width]
    I mov dx,[Height]

    I cld

    I mov ah,byte ptr Color
    I mov al,CenterFill

  looped:

    I push di
    I mov cx,bx
    I rep stosw
    I pop di
    I add di,ScreenWidth
    I dec dx
    I or dx,dx
    I jne looped

    X--;
    Y--;

    Width=SaveWide;
    Height=SaveHeight;
  }

  int Locator = ((WinY+Y)*ScreenWidth)+((WinX+X)*2);
  void far *OUTPUT=BlazeClass::OUTPUT;

  I les di,OUTPUT
  I add di,Locator

  ScreenWidth-=2;

  I mov bx,[Width]
  I sub bx,2
  I mov dx,[Height]
  I sub dx,2

  I mov ah,byte ptr Color
  I mov al,TopLeft
  I cld

  I stosw

  X++;

  if (_BX)
  {
    I mov cx,bx
    do                            // top
    {
      if (X<WinWide && Y<WinHigh)
      {
        I mov ah,byte ptr Color
        I mov al,TopCenter
        I stosw
      }
      else
      {
        I inc di
        I inc di
      }
      X++;
    }
    while (--_CX);
  }

  if (X<WinWide && Y<WinHigh)   // corner top right
  {
    I mov ah,byte ptr Color
    I mov al,TopRight
    I stosw
  }
  else
  {
    I inc di
    I inc di
  }

  I add di,ScreenWidth
  Y++;

  if (_DX)
  {
    I mov cx,dx
    do                            // right
    {
      if (X<WinWide && Y<WinHigh)
      {
        I mov ah,byte ptr Color
        I mov al,CenterRight
        I stosw
      }
      else
      {
        I inc di
        I inc di
      }
      I add di,ScreenWidth
      Y++;
    }
    while (--_CX);
  }

  I std

  if (X<WinWide && Y<WinHigh)   // corner bottom right
  {
    I mov ah,byte ptr Color
    I mov al,BottomRight
    I stosw
  }
  else
  {
    I dec di
    I dec di
  }

  X--;

  if (_BX)
  {
    I mov cx,bx
    do                            // bottom
    {
      if (X<WinWide && Y<WinHigh)
      {
        I mov ah,byte ptr Color
        I mov al,BottomCenter
        I stosw
      }
      else
      {
        I dec di
        I dec di
      }
      X--;
    }
    while (--_CX);
  }

  if (X<WinWide && Y<WinHigh)   // corner bottom left
  {
    I mov ah,byte ptr Color
    I mov al,BottomLeft
    I stosw
  }
  else
  {
    I dec di
    I dec di
  }

  I sub di,ScreenWidth
  Y--;

  if (_DX)
  {
    I mov cx,dx
    do                            // left
    {
      if (X<WinWide && Y<WinHigh)
      {
        I mov ah,byte ptr Color
        I mov al,CenterLeft
        I stosw
      }
      else
      {
        I dec di
        I dec di
      }
      I sub di,ScreenWidth
      Y--;
    }
    while (--_CX);
  }
}
