//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// BlazeClass
//

#ifndef __BCPLUSPLUS__
#pragma inline
#endif

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#define I asm

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Box()
//
// Draws an empty box on the screen
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void BlazeClass::Box(int X,int Y,int Width,int Height,int Color)
{
  if (Width<2 || Height<2 || X>=WinWide || Y>=WinHigh)
    return;

  char TopLeft = BlazeClass::TopLeft;
  char TopCenter = BlazeClass::TopCenter;
  char TopRight = BlazeClass::TopRight;
  char CenterLeft = BlazeClass::CenterLeft;
  char CenterRight = BlazeClass::CenterRight;
  char BottomLeft = BlazeClass::BottomLeft;
  char BottomCenter = BlazeClass::BottomCenter;
  char BottomRight = BlazeClass::BottomRight;

  int WinWide = BlazeClass::WinWide;
  int WinHigh = BlazeClass::WinHigh;
  int ScreenWidth = BlazeClass::QuickWidth;
  int Locator = ((WinY+Y)*ScreenWidth)+((WinX+X)*2);

  void far *OUTPUT=BlazeClass::OUTPUT;
  I les di,OUTPUT
  I add di,Locator

  ScreenWidth-=2;

  I mov bx,[Width]
  I sub bx,2
  I mov dx,[Height]
  I sub dx,2

  I mov ah,byte ptr Color
  I mov al,TopLeft
  I cld

  I stosw

  X++;

  if (_BX)
  {
    I mov cx,bx
    do                            // top
    {
      if (X<WinWide && Y<WinHigh)
      {
        I mov ah,byte ptr Color
        I mov al,TopCenter
        I stosw
      }
      else
      {
        I inc di
        I inc di
      }
      X++;
    }
    while (--_CX);
  }

  if (X<WinWide && Y<WinHigh)   // corner top right
  {
    I mov ah,byte ptr Color
    I mov al,TopRight
    I stosw
  }
  else
  {
    I inc di
    I inc di
  }

  I add di,ScreenWidth
  Y++;

  if (_DX)
  {
    I mov cx,dx
    do                            // right
    {
      if (X<WinWide && Y<WinHigh)
      {
        I mov ah,byte ptr Color
        I mov al,CenterRight
        I stosw
      }
      else
      {
        I inc di
        I inc di
      }
      I add di,ScreenWidth
      Y++;
    }
    while (--_CX);
  }

  I std

  if (X<WinWide && Y<WinHigh)   // corner bottom right
  {
    I mov ah,byte ptr Color
    I mov al,BottomRight
    I stosw
  }
  else
  {
    I dec di
    I dec di
  }

  X--;

  if (_BX)
  {
    I mov cx,bx
    do                            // bottom
    {
      if (X<WinWide && Y<WinHigh)
      {
        I mov ah,byte ptr Color
        I mov al,BottomCenter
        I stosw
      }
      else
      {
        I dec di
        I dec di
      }
      X--;
    }
    while (--_CX);
  }

  if (X<WinWide && Y<WinHigh)   // corner bottom left
  {
    I mov ah,byte ptr Color
    I mov al,BottomLeft
    I stosw
  }
  else
  {
    I dec di
    I dec di
  }

  I sub di,ScreenWidth
  Y--;

  if (_DX)
  {
    I mov cx,dx
    do                            // left
    {
      if (X<WinWide && Y<WinHigh)
      {
        I mov ah,byte ptr Color
        I mov al,CenterLeft
        I stosw
      }
      else
      {
        I dec di
        I dec di
      }
      I sub di,ScreenWidth
      Y--;
    }
    while (--_CX);
  }
}
