/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TEvent
#define Uses_TListViewer
#define Uses_TPalette
#define Uses_TInputRegExp
#define Uses_TStaticInputLine
#include "tvtools.h"
#include "strings.h"
#include "tools.h"
#include <ctype.h>


#define cpStaticInputLine "\x1A\x1A\x1C\x15"


const char * const TStaticInputLine::name = "TStaticInputLine";



static Boolean matchChars( void *item, void *target )
{
  int len = strlen( (char *)target );
  if ( ! len ) return False;

  return strncomp((char *)item, (char *)target, len) == 0 ;
}


TStaticInputLine::TStaticInputLine( const TRect& bounds,
                                    int aMaxLen,
                                    TGenCollection *aList
                                  ):
		  TInputRegExp( bounds, aMaxLen )
{
  list = aList;
}


TStaticInputLine::TStaticInputLine( int x, int y,
                                    int aMaxLen,
                                    TGenCollection *aList
                                  ):
		  TInputRegExp( x, y, aMaxLen )
{
  list = aList;
}

void TStaticInputLine::setData( void *rec )
{
  if ( ! list->firstThat(matchChars, (char*)rec) )
     (char*)rec = list->getData(0);

  TInputRegExp::setData( rec );
}

void TStaticInputLine::handleEvent(TEvent& event)
{
  if ( event.what == evKeyDown )
     {
       if ( isprint(event.keyDown.charScan.charCode) )
          {
            // Add character to buffer string
            char *tempData = strend( testChar );
            *tempData++ = event.keyDown.charScan.charCode;
            *tempData = EOS;

            tempData = (char *)list->firstThat(matchChars, testChar);
            if ( tempData )
               {
                 strncpy( data, tempData, maxLen );
                 data[maxLen] = EOS;
                 selectAll( True );
                 drawView();
               }
            else { testChar[strlen(testChar) - 1] = EOS;
                   buzzer();
                 }
            clearEvent( event );
            return;
          }

       int off = 0;

       switch( event.keyDown.keyCode )
        {
          case kbLeft : off = -1;
          case kbRight: if ( ! off ) off = 1;
          case kbHome : if ( ! off ) off = - list->getCount();
          case kbEnd  : if ( ! off ) off = list->getCount();

                        if ( list->getCount() )
                           {
                             ccIndex index = list->indexOf( (char *)list->firstThat(matchChars, data) );
                             index += off;
	                     if ( index < 0 ) index = 0;
 	                     if ( index >= list->getCount() ) index = list->getCount() - 1;
	                     strncpy( data, list->getData(index), maxLen );
                             data[maxLen] = EOS;
                           }

                        *testChar = EOS;

	                selectAll( True );
	                drawView();
	                clearEvent( event );
                        return;

     	   case kbUp   :
	   case kbIns  : *testChar = EOS;
                         clearEvent(event);
                         return;

     	   case kbDel     :
	   case kbBack    : *testChar = EOS;
                            break;
         }
     }

  if ( event.what == evMouseDown ) *testChar = EOS;

  TInputRegExp::handleEvent( event );
}


Boolean TStaticInputLine::valid( ushort command )
{
  if ( command == cmReleasedFocus ) *testChar = EOS;

  return TInputRegExp::valid( command );
}

void TStaticInputLine::newList( TGenCollection *aList )
{
  if ( list ) destroy( list );
  list = aList;
  drawView();
}

/*
TPalette& TStaticInputLine::getPalette() const
{
  static TPalette palette( cpStaticInputLine, sizeof( cpStaticInputLine)-1 );
  return palette;
}
*/
