/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TButton
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TLabel
#define Uses_TProgram
#define Uses_TStreamable
#define Uses_MsgBox
#define Uses_TInputPasswd
#include "tvtools.h"
__link( RInputLine )


#include <string.h>
#include <stdio.h>
#include <values.h>
#include <stdlib.h>
#include <strstream.h>


// TInputPasswd

const char *const TInputPasswd::name = "TInputPasswd";

TStreamable *TInputPasswd::build()
{
  return new TInputPasswd( streamableInit );
}

TInputPasswd::TInputPasswd( const TRect& bounds, int aMaxLen )
             :TInputLine( bounds, aMaxLen )
{
}

TStreamableClass RInputPasswd( TInputPasswd::name,
                               TInputPasswd::build,
                               __DELTA(TInputPasswd)
                             );


void TInputPasswd::draw()
{
    char stars[256], *inData = data;
    int len = strlen( inData );

    memset( stars, '*', len );
    stars[len] = EOS;
    data = stars;
    TInputLine::draw();
    data = inData;
}



ushort inputPasswdBoxRect( const TRect &bounds,
                           const char *Title,
                           const char *aLabel,
                           char *s,
                           uchar limit )
{
    TDialog *dialog;
    TView* control;
    TRect r;

    dialog = new TDialog(bounds, Title);

    uchar x = 4 + strlen( aLabel );
    r = TRect( x, 2, min(x + limit + 2, dialog->size.x - 3), 3 );
    control = new TInputPasswd( r, limit );
    dialog->insert( control );

    r = TRect( 2, 2, 3 + strlen(aLabel), 3 );
    dialog->insert( new TLabel( r, aLabel, control ) );

    OKCancelButtons( dialog );

    dialog->selectNext(False);
    *s = EOS;
    return execDialog( dialog, s );
}


ushort inputPasswdBox( const char *Title, const char *aLabel, char *s, uchar limit )
{
    ushort len = max( strlen(aLabel) + 9 + limit, strlen(Title) + 10 );
    len = min( len, 60 );
    len = max( len , 24 );
    TRect r(0, 0, len, 8);
    r.move((TProgram::deskTop->size.x - r.b.x) / 2,
           (TProgram::deskTop->size.y - r.b.y) / 2);
    return inputPasswdBoxRect(r, Title, aLabel, s, limit);
}

