/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TStreamable
#define Uses_MsgBox
#define Uses_TInputCalcul
#include <math.h>
#include "calc.h"
#include "tvtools.h"
__link( RInputLine )


#include <string.h>
#include <stdio.h>
#include <values.h>
#include <stdlib.h>
#include <strstream.h>


// TInputCalcul

const char *const TInputCalcul::name = "TInputCalcul";

TStreamable *TInputCalcul::build()
{
  return new TInputCalcul( streamableInit );
}

TInputCalcul::TInputCalcul( const TRect& bounds, int aMaxLen )
             :TInputRegExp( bounds, aMaxLen, "-+*/%<>=.0-9" )
{
}

TInputCalcul::TInputCalcul(  int x, int y, int aMaxLen )
             :TInputRegExp( x, y, aMaxLen, "-+*/%<>=.0-9" )
{
}

TStreamableClass RInputCalcul( TInputCalcul::name,
                               TInputCalcul::build,
                               __DELTA(TInputCalcul)
                             );


Boolean TInputCalcul::valid( ushort command )
{
  switch( command )
        {
          case cmReleasedFocus: return True;

          case cmQuit :
          case cmClose:
          case cmOK   : if ( calc(data) >= HUGE_VAL )
                           {
                             select();
                             messageBox( "\03Cannot calculate this.",
                                         mfError | mfOKButton
                                       );
                             return False;
                           }
                        break;
        }

  return TInputRegExp::valid(command);
}

